/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.utils;

import io.ballerina.compiler.internal.parser.BallerinaParser;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.parser.tree.STQualifiedNameReferenceNode;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.SyntaxKind;

public final class ConditionalExprResolver {
    private static final String BOOLEAN = "boolean";
    private static final String DECIMAL = "decimal";
    private static final String FLOAT = "float";
    private static final String INT = "int";
    private static final String STRING = "string";
    private static final String ERROR = "error";
    private static final String FUTURE = "future";
    private static final String MAP = "map";
    private static final String OBJECT = "object";
    private static final String STREAM = "stream";
    private static final String TABLE = "table";
    private static final String TRANSACTION = "transaction";
    private static final String TYPEDESC = "typedesc";
    private static final String XML = "xml";

    private ConditionalExprResolver() {
    }

    public static STNode getQualifiedNameRefNode(STNode parentNode, boolean leftMost) {
        STNode firstOrLastChild;
        if (parentNode == null || parentNode.kind == SyntaxKind.LIST && ((STNodeList)parentNode).isEmpty()) {
            return null;
        }
        if (parentNode.kind == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            STNode modulePrefix = ((STQualifiedNameReferenceNode)parentNode).modulePrefix;
            return ConditionalExprResolver.isValidSimpleNameRef((STToken)modulePrefix) ? parentNode : null;
        }
        STNode sTNode = firstOrLastChild = leftMost ? parentNode.childInBucket(0) : parentNode.childInBucket(parentNode.bucketCount() - 1);
        if (SyntaxUtils.isNonTerminalNode(firstOrLastChild)) {
            return ConditionalExprResolver.getQualifiedNameRefNode(firstOrLastChild, leftMost);
        }
        return null;
    }

    private static boolean isValidSimpleNameRef(STToken modulePrefixIdentifier) {
        return switch (modulePrefixIdentifier.text()) {
            case ERROR, FUTURE, MAP, OBJECT, STREAM, TABLE, TRANSACTION, TYPEDESC, XML -> false;
            default -> true;
        };
    }

    public static STNode getSimpleNameRefNode(STNode modulePrefixIdentifier) {
        STToken syntaxToken;
        STToken identifier = (STToken)modulePrefixIdentifier;
        switch (identifier.text()) {
            case "boolean": {
                syntaxToken = STNodeFactory.createToken(SyntaxKind.BOOLEAN_KEYWORD, identifier.leadingMinutiae(), identifier.trailingMinutiae());
                break;
            }
            case "decimal": {
                syntaxToken = STNodeFactory.createToken(SyntaxKind.DECIMAL_KEYWORD, identifier.leadingMinutiae(), identifier.trailingMinutiae());
                break;
            }
            case "float": {
                syntaxToken = STNodeFactory.createToken(SyntaxKind.FLOAT_KEYWORD, identifier.leadingMinutiae(), identifier.trailingMinutiae());
                break;
            }
            case "int": {
                syntaxToken = STNodeFactory.createToken(SyntaxKind.INT_KEYWORD, identifier.leadingMinutiae(), identifier.trailingMinutiae());
                break;
            }
            case "string": {
                syntaxToken = STNodeFactory.createToken(SyntaxKind.STRING_KEYWORD, identifier.leadingMinutiae(), identifier.trailingMinutiae());
                break;
            }
            default: {
                return STNodeFactory.createSimpleNameReferenceNode(identifier);
            }
        }
        return BallerinaParser.createBuiltinSimpleNameReference(syntaxToken);
    }
}

