/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ClientResourceAccessActionNode
extends ActionNode {
    public ClientResourceAccessActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token rightArrowToken() {
        return (Token)this.childInBucket(1);
    }

    public Token slashToken() {
        return (Token)this.childInBucket(2);
    }

    public SeparatedNodeList<Node> resourceAccessPath() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(3));
    }

    public Optional<Token> dotToken() {
        return this.optionalChildInBucket(4);
    }

    public Optional<SimpleNameReferenceNode> methodName() {
        return this.optionalChildInBucket(5);
    }

    public Optional<ParenthesizedArgList> arguments() {
        return this.optionalChildInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "rightArrowToken", "slashToken", "resourceAccessPath", "dotToken", "methodName", "arguments"};
    }

    public ClientResourceAccessActionNode modify(ExpressionNode expression, Token rightArrowToken, Token slashToken, SeparatedNodeList<Node> resourceAccessPath, Token dotToken, SimpleNameReferenceNode methodName, ParenthesizedArgList arguments) {
        if (this.checkForReferenceEquality(expression, rightArrowToken, slashToken, resourceAccessPath.underlyingListNode(), dotToken, methodName, arguments)) {
            return this;
        }
        return NodeFactory.createClientResourceAccessActionNode(expression, rightArrowToken, slashToken, resourceAccessPath, dotToken, methodName, arguments);
    }

    public ClientResourceAccessActionNodeModifier modify() {
        return new ClientResourceAccessActionNodeModifier(this);
    }

    public static class ClientResourceAccessActionNodeModifier {
        private final ClientResourceAccessActionNode oldNode;
        private ExpressionNode expression;
        private Token rightArrowToken;
        private Token slashToken;
        private SeparatedNodeList<Node> resourceAccessPath;
        private Token dotToken;
        private SimpleNameReferenceNode methodName;
        private ParenthesizedArgList arguments;

        public ClientResourceAccessActionNodeModifier(ClientResourceAccessActionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.rightArrowToken = oldNode.rightArrowToken();
            this.slashToken = oldNode.slashToken();
            this.resourceAccessPath = oldNode.resourceAccessPath();
            this.dotToken = oldNode.dotToken().orElse(null);
            this.methodName = oldNode.methodName().orElse(null);
            this.arguments = oldNode.arguments().orElse(null);
        }

        public ClientResourceAccessActionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public ClientResourceAccessActionNodeModifier withRightArrowToken(Token rightArrowToken) {
            Objects.requireNonNull(rightArrowToken, "rightArrowToken must not be null");
            this.rightArrowToken = rightArrowToken;
            return this;
        }

        public ClientResourceAccessActionNodeModifier withSlashToken(Token slashToken) {
            Objects.requireNonNull(slashToken, "slashToken must not be null");
            this.slashToken = slashToken;
            return this;
        }

        public ClientResourceAccessActionNodeModifier withResourceAccessPath(SeparatedNodeList<Node> resourceAccessPath) {
            Objects.requireNonNull(resourceAccessPath, "resourceAccessPath must not be null");
            this.resourceAccessPath = resourceAccessPath;
            return this;
        }

        public ClientResourceAccessActionNodeModifier withDotToken(Token dotToken) {
            this.dotToken = dotToken;
            return this;
        }

        public ClientResourceAccessActionNodeModifier withMethodName(SimpleNameReferenceNode methodName) {
            this.methodName = methodName;
            return this;
        }

        public ClientResourceAccessActionNodeModifier withArguments(ParenthesizedArgList arguments) {
            this.arguments = arguments;
            return this;
        }

        public ClientResourceAccessActionNode apply() {
            return this.oldNode.modify(this.expression, this.rightArrowToken, this.slashToken, this.resourceAccessPath, this.dotToken, this.methodName, this.arguments);
        }
    }
}

