/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class FieldMatchPatternNode
extends NonTerminalNode {
    public FieldMatchPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public IdentifierToken fieldNameNode() {
        return (IdentifierToken)this.childInBucket(0);
    }

    public Token colonToken() {
        return (Token)this.childInBucket(1);
    }

    public Node matchPattern() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"fieldNameNode", "colonToken", "matchPattern"};
    }

    public FieldMatchPatternNode modify(IdentifierToken fieldNameNode, Token colonToken, Node matchPattern) {
        if (this.checkForReferenceEquality(fieldNameNode, colonToken, matchPattern)) {
            return this;
        }
        return NodeFactory.createFieldMatchPatternNode(fieldNameNode, colonToken, matchPattern);
    }

    public FieldMatchPatternNodeModifier modify() {
        return new FieldMatchPatternNodeModifier(this);
    }

    public static class FieldMatchPatternNodeModifier {
        private final FieldMatchPatternNode oldNode;
        private IdentifierToken fieldNameNode;
        private Token colonToken;
        private Node matchPattern;

        public FieldMatchPatternNodeModifier(FieldMatchPatternNode oldNode) {
            this.oldNode = oldNode;
            this.fieldNameNode = oldNode.fieldNameNode();
            this.colonToken = oldNode.colonToken();
            this.matchPattern = oldNode.matchPattern();
        }

        public FieldMatchPatternNodeModifier withFieldNameNode(IdentifierToken fieldNameNode) {
            Objects.requireNonNull(fieldNameNode, "fieldNameNode must not be null");
            this.fieldNameNode = fieldNameNode;
            return this;
        }

        public FieldMatchPatternNodeModifier withColonToken(Token colonToken) {
            Objects.requireNonNull(colonToken, "colonToken must not be null");
            this.colonToken = colonToken;
            return this;
        }

        public FieldMatchPatternNodeModifier withMatchPattern(Node matchPattern) {
            Objects.requireNonNull(matchPattern, "matchPattern must not be null");
            this.matchPattern = matchPattern;
            return this;
        }

        public FieldMatchPatternNode apply() {
            return this.oldNode.modify(this.fieldNameNode, this.colonToken, this.matchPattern);
        }
    }
}

