/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ForkStatementNode
extends StatementNode {
    public ForkStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token forkKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(1);
    }

    public NodeList<NamedWorkerDeclarationNode> namedWorkerDeclarations() {
        return new NodeList<NamedWorkerDeclarationNode>((NonTerminalNode)this.childInBucket(2));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"forkKeyword", "openBraceToken", "namedWorkerDeclarations", "closeBraceToken"};
    }

    public ForkStatementNode modify(Token forkKeyword, Token openBraceToken, NodeList<NamedWorkerDeclarationNode> namedWorkerDeclarations, Token closeBraceToken) {
        if (this.checkForReferenceEquality(forkKeyword, openBraceToken, namedWorkerDeclarations.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createForkStatementNode(forkKeyword, openBraceToken, namedWorkerDeclarations, closeBraceToken);
    }

    public ForkStatementNodeModifier modify() {
        return new ForkStatementNodeModifier(this);
    }

    public static class ForkStatementNodeModifier {
        private final ForkStatementNode oldNode;
        private Token forkKeyword;
        private Token openBraceToken;
        private NodeList<NamedWorkerDeclarationNode> namedWorkerDeclarations;
        private Token closeBraceToken;

        public ForkStatementNodeModifier(ForkStatementNode oldNode) {
            this.oldNode = oldNode;
            this.forkKeyword = oldNode.forkKeyword();
            this.openBraceToken = oldNode.openBraceToken();
            this.namedWorkerDeclarations = oldNode.namedWorkerDeclarations();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public ForkStatementNodeModifier withForkKeyword(Token forkKeyword) {
            Objects.requireNonNull(forkKeyword, "forkKeyword must not be null");
            this.forkKeyword = forkKeyword;
            return this;
        }

        public ForkStatementNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public ForkStatementNodeModifier withNamedWorkerDeclarations(NodeList<NamedWorkerDeclarationNode> namedWorkerDeclarations) {
            Objects.requireNonNull(namedWorkerDeclarations, "namedWorkerDeclarations must not be null");
            this.namedWorkerDeclarations = namedWorkerDeclarations;
            return this;
        }

        public ForkStatementNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public ForkStatementNode apply() {
            return this.oldNode.modify(this.forkKeyword, this.openBraceToken, this.namedWorkerDeclarations, this.closeBraceToken);
        }
    }
}

