/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ImplicitNewExpressionNode
extends NewExpressionNode {
    public ImplicitNewExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token newKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<ParenthesizedArgList> parenthesizedArgList() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"newKeyword", "parenthesizedArgList"};
    }

    public ImplicitNewExpressionNode modify(Token newKeyword, ParenthesizedArgList parenthesizedArgList) {
        if (this.checkForReferenceEquality(newKeyword, parenthesizedArgList)) {
            return this;
        }
        return NodeFactory.createImplicitNewExpressionNode(newKeyword, parenthesizedArgList);
    }

    public ImplicitNewExpressionNodeModifier modify() {
        return new ImplicitNewExpressionNodeModifier(this);
    }

    public static class ImplicitNewExpressionNodeModifier {
        private final ImplicitNewExpressionNode oldNode;
        private Token newKeyword;
        private ParenthesizedArgList parenthesizedArgList;

        public ImplicitNewExpressionNodeModifier(ImplicitNewExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.newKeyword = oldNode.newKeyword();
            this.parenthesizedArgList = oldNode.parenthesizedArgList().orElse(null);
        }

        public ImplicitNewExpressionNodeModifier withNewKeyword(Token newKeyword) {
            Objects.requireNonNull(newKeyword, "newKeyword must not be null");
            this.newKeyword = newKeyword;
            return this;
        }

        public ImplicitNewExpressionNodeModifier withParenthesizedArgList(ParenthesizedArgList parenthesizedArgList) {
            this.parenthesizedArgList = parenthesizedArgList;
            return this;
        }

        public ImplicitNewExpressionNode apply() {
            return this.oldNode.modify(this.newKeyword, this.parenthesizedArgList);
        }
    }
}

