/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnClauseNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;
import java.util.Optional;

public class JoinClauseNode
extends IntermediateClauseNode {
    public JoinClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> outerKeyword() {
        return this.optionalChildInBucket(0);
    }

    public Token joinKeyword() {
        return (Token)this.childInBucket(1);
    }

    public TypedBindingPatternNode typedBindingPattern() {
        return (TypedBindingPatternNode)this.childInBucket(2);
    }

    public Token inKeyword() {
        return (Token)this.childInBucket(3);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(4);
    }

    public OnClauseNode joinOnCondition() {
        return (OnClauseNode)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"outerKeyword", "joinKeyword", "typedBindingPattern", "inKeyword", "expression", "joinOnCondition"};
    }

    public JoinClauseNode modify(Token outerKeyword, Token joinKeyword, TypedBindingPatternNode typedBindingPattern, Token inKeyword, ExpressionNode expression, OnClauseNode joinOnCondition) {
        if (this.checkForReferenceEquality(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, joinOnCondition)) {
            return this;
        }
        return NodeFactory.createJoinClauseNode(outerKeyword, joinKeyword, typedBindingPattern, inKeyword, expression, joinOnCondition);
    }

    public JoinClauseNodeModifier modify() {
        return new JoinClauseNodeModifier(this);
    }

    public static class JoinClauseNodeModifier {
        private final JoinClauseNode oldNode;
        private Token outerKeyword;
        private Token joinKeyword;
        private TypedBindingPatternNode typedBindingPattern;
        private Token inKeyword;
        private ExpressionNode expression;
        private OnClauseNode joinOnCondition;

        public JoinClauseNodeModifier(JoinClauseNode oldNode) {
            this.oldNode = oldNode;
            this.outerKeyword = oldNode.outerKeyword().orElse(null);
            this.joinKeyword = oldNode.joinKeyword();
            this.typedBindingPattern = oldNode.typedBindingPattern();
            this.inKeyword = oldNode.inKeyword();
            this.expression = oldNode.expression();
            this.joinOnCondition = oldNode.joinOnCondition();
        }

        public JoinClauseNodeModifier withOuterKeyword(Token outerKeyword) {
            this.outerKeyword = outerKeyword;
            return this;
        }

        public JoinClauseNodeModifier withJoinKeyword(Token joinKeyword) {
            Objects.requireNonNull(joinKeyword, "joinKeyword must not be null");
            this.joinKeyword = joinKeyword;
            return this;
        }

        public JoinClauseNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            Objects.requireNonNull(typedBindingPattern, "typedBindingPattern must not be null");
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public JoinClauseNodeModifier withInKeyword(Token inKeyword) {
            Objects.requireNonNull(inKeyword, "inKeyword must not be null");
            this.inKeyword = inKeyword;
            return this;
        }

        public JoinClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public JoinClauseNodeModifier withJoinOnCondition(OnClauseNode joinOnCondition) {
            Objects.requireNonNull(joinOnCondition, "joinOnCondition must not be null");
            this.joinOnCondition = joinOnCondition;
            return this;
        }

        public JoinClauseNode apply() {
            return this.oldNode.modify(this.outerKeyword, this.joinKeyword, this.typedBindingPattern, this.inKeyword, this.expression, this.joinOnCondition);
        }
    }
}

