/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class LimitClauseNode
extends IntermediateClauseNode {
    public LimitClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token limitKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"limitKeyword", "expression"};
    }

    public LimitClauseNode modify(Token limitKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(limitKeyword, expression)) {
            return this;
        }
        return NodeFactory.createLimitClauseNode(limitKeyword, expression);
    }

    public LimitClauseNodeModifier modify() {
        return new LimitClauseNodeModifier(this);
    }

    public static class LimitClauseNodeModifier {
        private final LimitClauseNode oldNode;
        private Token limitKeyword;
        private ExpressionNode expression;

        public LimitClauseNodeModifier(LimitClauseNode oldNode) {
            this.oldNode = oldNode;
            this.limitKeyword = oldNode.limitKeyword();
            this.expression = oldNode.expression();
        }

        public LimitClauseNodeModifier withLimitKeyword(Token limitKeyword) {
            Objects.requireNonNull(limitKeyword, "limitKeyword must not be null");
            this.limitKeyword = limitKeyword;
            return this;
        }

        public LimitClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public LimitClauseNode apply() {
            return this.oldNode.modify(this.limitKeyword, this.expression);
        }
    }
}

