/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MarkdownParameterDocumentationLineNode
extends DocumentationNode {
    public MarkdownParameterDocumentationLineNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token hashToken() {
        return (Token)this.childInBucket(0);
    }

    public Token plusToken() {
        return (Token)this.childInBucket(1);
    }

    public Token parameterName() {
        return (Token)this.childInBucket(2);
    }

    public Token minusToken() {
        return (Token)this.childInBucket(3);
    }

    public NodeList<Node> documentElements() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(4));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"hashToken", "plusToken", "parameterName", "minusToken", "documentElements"};
    }

    public MarkdownParameterDocumentationLineNode modify(SyntaxKind kind, Token hashToken, Token plusToken, Token parameterName, Token minusToken, NodeList<Node> documentElements) {
        if (this.checkForReferenceEquality(hashToken, plusToken, parameterName, minusToken, documentElements.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createMarkdownParameterDocumentationLineNode(kind, hashToken, plusToken, parameterName, minusToken, documentElements);
    }

    public MarkdownParameterDocumentationLineNodeModifier modify() {
        return new MarkdownParameterDocumentationLineNodeModifier(this);
    }

    public static class MarkdownParameterDocumentationLineNodeModifier {
        private final MarkdownParameterDocumentationLineNode oldNode;
        private Token hashToken;
        private Token plusToken;
        private Token parameterName;
        private Token minusToken;
        private NodeList<Node> documentElements;

        public MarkdownParameterDocumentationLineNodeModifier(MarkdownParameterDocumentationLineNode oldNode) {
            this.oldNode = oldNode;
            this.hashToken = oldNode.hashToken();
            this.plusToken = oldNode.plusToken();
            this.parameterName = oldNode.parameterName();
            this.minusToken = oldNode.minusToken();
            this.documentElements = oldNode.documentElements();
        }

        public MarkdownParameterDocumentationLineNodeModifier withHashToken(Token hashToken) {
            Objects.requireNonNull(hashToken, "hashToken must not be null");
            this.hashToken = hashToken;
            return this;
        }

        public MarkdownParameterDocumentationLineNodeModifier withPlusToken(Token plusToken) {
            Objects.requireNonNull(plusToken, "plusToken must not be null");
            this.plusToken = plusToken;
            return this;
        }

        public MarkdownParameterDocumentationLineNodeModifier withParameterName(Token parameterName) {
            Objects.requireNonNull(parameterName, "parameterName must not be null");
            this.parameterName = parameterName;
            return this;
        }

        public MarkdownParameterDocumentationLineNodeModifier withMinusToken(Token minusToken) {
            Objects.requireNonNull(minusToken, "minusToken must not be null");
            this.minusToken = minusToken;
            return this;
        }

        public MarkdownParameterDocumentationLineNodeModifier withDocumentElements(NodeList<Node> documentElements) {
            Objects.requireNonNull(documentElements, "documentElements must not be null");
            this.documentElements = documentElements;
            return this;
        }

        public MarkdownParameterDocumentationLineNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.hashToken, this.plusToken, this.parameterName, this.minusToken, this.documentElements);
        }
    }
}

