/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STInvalidNodeMinutiae;
import io.ballerina.compiler.internal.parser.tree.STMinutiae;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.InvalidTokenMinutiaeNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Optional;

public final class Minutiae {
    private final STMinutiae internalMinutiae;
    private final Token token;
    private final int position;
    private TextRange textRange;
    private LineRange lineRange;

    Minutiae(STMinutiae internalMinutiae, Token token, int position) {
        this.internalMinutiae = internalMinutiae;
        this.token = token;
        this.position = position;
    }

    static Minutiae createUnlinked(STMinutiae internalMinutiae) {
        return new Minutiae(internalMinutiae, null, -1);
    }

    public String text() {
        return this.internalMinutiae.text();
    }

    public SyntaxKind kind() {
        return this.internalMinutiae.kind;
    }

    public Token parentToken() {
        return this.token;
    }

    public boolean isInvalidNodeMinutiae() {
        return SyntaxKind.INVALID_NODE_MINUTIAE == this.internalMinutiae.kind;
    }

    public Optional<InvalidTokenMinutiaeNode> invalidTokenMinutiaeNode() {
        if (!this.isInvalidNodeMinutiae()) {
            return Optional.empty();
        }
        STInvalidNodeMinutiae minutiae = (STInvalidNodeMinutiae)this.internalMinutiae;
        return Optional.of(new InvalidTokenMinutiaeNode(minutiae.invalidNode(), this.position, this, this.token.syntaxTree()));
    }

    public TextRange textRange() {
        if (this.textRange != null) {
            return this.textRange;
        }
        this.textRange = TextRange.from(this.position, this.internalMinutiae.width());
        return this.textRange;
    }

    public LineRange lineRange() {
        if (this.lineRange != null) {
            return this.lineRange;
        }
        SyntaxTree syntaxTree = this.token.syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        this.lineRange = LineRange.from(syntaxTree.filePath(), textDocument.linePositionFrom(this.textRange().startOffset()), textDocument.linePositionFrom(this.textRange().endOffset()));
        return this.lineRange;
    }

    STNode internalNode() {
        return this.internalMinutiae;
    }
}

