/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class RecordFieldWithDefaultValueNode
extends NonTerminalNode {
    public RecordFieldWithDefaultValueNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> readonlyKeyword() {
        return this.optionalChildInBucket(1);
    }

    public Node typeName() {
        return this.childInBucket(2);
    }

    public Token fieldName() {
        return (Token)this.childInBucket(3);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(4);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(5);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "readonlyKeyword", "typeName", "fieldName", "equalsToken", "expression", "semicolonToken"};
    }

    public RecordFieldWithDefaultValueNode modify(MetadataNode metadata, Token readonlyKeyword, Node typeName, Token fieldName, Token equalsToken, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, readonlyKeyword, typeName, fieldName, equalsToken, expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createRecordFieldWithDefaultValueNode(metadata, readonlyKeyword, typeName, fieldName, equalsToken, expression, semicolonToken);
    }

    public RecordFieldWithDefaultValueNodeModifier modify() {
        return new RecordFieldWithDefaultValueNodeModifier(this);
    }

    public static class RecordFieldWithDefaultValueNodeModifier {
        private final RecordFieldWithDefaultValueNode oldNode;
        private MetadataNode metadata;
        private Token readonlyKeyword;
        private Node typeName;
        private Token fieldName;
        private Token equalsToken;
        private ExpressionNode expression;
        private Token semicolonToken;

        public RecordFieldWithDefaultValueNodeModifier(RecordFieldWithDefaultValueNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.readonlyKeyword = oldNode.readonlyKeyword().orElse(null);
            this.typeName = oldNode.typeName();
            this.fieldName = oldNode.fieldName();
            this.equalsToken = oldNode.equalsToken();
            this.expression = oldNode.expression();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public RecordFieldWithDefaultValueNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public RecordFieldWithDefaultValueNodeModifier withReadonlyKeyword(Token readonlyKeyword) {
            this.readonlyKeyword = readonlyKeyword;
            return this;
        }

        public RecordFieldWithDefaultValueNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public RecordFieldWithDefaultValueNodeModifier withFieldName(Token fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public RecordFieldWithDefaultValueNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public RecordFieldWithDefaultValueNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public RecordFieldWithDefaultValueNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public RecordFieldWithDefaultValueNode apply() {
            return this.oldNode.modify(this.metadata, this.readonlyKeyword, this.typeName, this.fieldName, this.equalsToken, this.expression, this.semicolonToken);
        }
    }
}

