/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class SelectClauseNode
extends ClauseNode {
    public SelectClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token selectKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"selectKeyword", "expression"};
    }

    public SelectClauseNode modify(Token selectKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(selectKeyword, expression)) {
            return this;
        }
        return NodeFactory.createSelectClauseNode(selectKeyword, expression);
    }

    public SelectClauseNodeModifier modify() {
        return new SelectClauseNodeModifier(this);
    }

    public static class SelectClauseNodeModifier {
        private final SelectClauseNode oldNode;
        private Token selectKeyword;
        private ExpressionNode expression;

        public SelectClauseNodeModifier(SelectClauseNode oldNode) {
            this.oldNode = oldNode;
            this.selectKeyword = oldNode.selectKeyword();
            this.expression = oldNode.expression();
        }

        public SelectClauseNodeModifier withSelectKeyword(Token selectKeyword) {
            Objects.requireNonNull(selectKeyword, "selectKeyword must not be null");
            this.selectKeyword = selectKeyword;
            return this;
        }

        public SelectClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public SelectClauseNode apply() {
            return this.oldNode.modify(this.selectKeyword, this.expression);
        }
    }
}

