/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class SpreadMemberNode
extends NonTerminalNode {
    public SpreadMemberNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ellipsis() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ellipsis", "expression"};
    }

    public SpreadMemberNode modify(Token ellipsis, ExpressionNode expression) {
        if (this.checkForReferenceEquality(ellipsis, expression)) {
            return this;
        }
        return NodeFactory.createSpreadMemberNode(ellipsis, expression);
    }

    public SpreadMemberNodeModifier modify() {
        return new SpreadMemberNodeModifier(this);
    }

    public static class SpreadMemberNodeModifier {
        private final SpreadMemberNode oldNode;
        private Token ellipsis;
        private ExpressionNode expression;

        public SpreadMemberNodeModifier(SpreadMemberNode oldNode) {
            this.oldNode = oldNode;
            this.ellipsis = oldNode.ellipsis();
            this.expression = oldNode.expression();
        }

        public SpreadMemberNodeModifier withEllipsis(Token ellipsis) {
            Objects.requireNonNull(ellipsis, "ellipsis must not be null");
            this.ellipsis = ellipsis;
            return this;
        }

        public SpreadMemberNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public SpreadMemberNode apply() {
            return this.oldNode.modify(this.ellipsis, this.expression);
        }
    }
}

