/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class StreamTypeDescriptorNode
extends TypeDescriptorNode {
    public StreamTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token streamKeywordToken() {
        return (Token)this.childInBucket(0);
    }

    public Optional<Node> streamTypeParamsNode() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"streamKeywordToken", "streamTypeParamsNode"};
    }

    public StreamTypeDescriptorNode modify(Token streamKeywordToken, Node streamTypeParamsNode) {
        if (this.checkForReferenceEquality(streamKeywordToken, streamTypeParamsNode)) {
            return this;
        }
        return NodeFactory.createStreamTypeDescriptorNode(streamKeywordToken, streamTypeParamsNode);
    }

    public StreamTypeDescriptorNodeModifier modify() {
        return new StreamTypeDescriptorNodeModifier(this);
    }

    public static class StreamTypeDescriptorNodeModifier {
        private final StreamTypeDescriptorNode oldNode;
        private Token streamKeywordToken;
        private Node streamTypeParamsNode;

        public StreamTypeDescriptorNodeModifier(StreamTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.streamKeywordToken = oldNode.streamKeywordToken();
            this.streamTypeParamsNode = oldNode.streamTypeParamsNode().orElse(null);
        }

        public StreamTypeDescriptorNodeModifier withStreamKeywordToken(Token streamKeywordToken) {
            Objects.requireNonNull(streamKeywordToken, "streamKeywordToken must not be null");
            this.streamKeywordToken = streamKeywordToken;
            return this;
        }

        public StreamTypeDescriptorNodeModifier withStreamTypeParamsNode(Node streamTypeParamsNode) {
            this.streamTypeParamsNode = streamTypeParamsNode;
            return this;
        }

        public StreamTypeDescriptorNode apply() {
            return this.oldNode.modify(this.streamKeywordToken, this.streamTypeParamsNode);
        }
    }
}

