/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class TemplateExpressionNode
extends ExpressionNode {
    public TemplateExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> type() {
        return this.optionalChildInBucket(0);
    }

    public Token startBacktick() {
        return (Token)this.childInBucket(1);
    }

    public NodeList<Node> content() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(2));
    }

    public Token endBacktick() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"type", "startBacktick", "content", "endBacktick"};
    }

    public TemplateExpressionNode modify(SyntaxKind kind, Token type, Token startBacktick, NodeList<Node> content, Token endBacktick) {
        if (this.checkForReferenceEquality(type, startBacktick, content.underlyingListNode(), endBacktick)) {
            return this;
        }
        return NodeFactory.createTemplateExpressionNode(kind, type, startBacktick, content, endBacktick);
    }

    public TemplateExpressionNodeModifier modify() {
        return new TemplateExpressionNodeModifier(this);
    }

    public static class TemplateExpressionNodeModifier {
        private final TemplateExpressionNode oldNode;
        private Token type;
        private Token startBacktick;
        private NodeList<Node> content;
        private Token endBacktick;

        public TemplateExpressionNodeModifier(TemplateExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.type = oldNode.type().orElse(null);
            this.startBacktick = oldNode.startBacktick();
            this.content = oldNode.content();
            this.endBacktick = oldNode.endBacktick();
        }

        public TemplateExpressionNodeModifier withType(Token type) {
            this.type = type;
            return this;
        }

        public TemplateExpressionNodeModifier withStartBacktick(Token startBacktick) {
            Objects.requireNonNull(startBacktick, "startBacktick must not be null");
            this.startBacktick = startBacktick;
            return this;
        }

        public TemplateExpressionNodeModifier withContent(NodeList<Node> content) {
            Objects.requireNonNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public TemplateExpressionNodeModifier withEndBacktick(Token endBacktick) {
            Objects.requireNonNull(endBacktick, "endBacktick must not be null");
            this.endBacktick = endBacktick;
            return this;
        }

        public TemplateExpressionNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.type, this.startBacktick, this.content, this.endBacktick);
        }
    }
}

