/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Token
extends Node {
    protected MinutiaeList leadingMinutiaeList;
    protected MinutiaeList trailingMinutiaeList;

    public Token(STNode token, int position, NonTerminalNode parent) {
        super(token, position, parent);
    }

    public String text() {
        return ((STToken)this.internalNode).text();
    }

    public boolean containsLeadingMinutiae() {
        return this.internalNode.leadingMinutiae().bucketCount() > 0;
    }

    @Override
    public MinutiaeList leadingMinutiae() {
        if (this.leadingMinutiaeList != null) {
            return this.leadingMinutiaeList;
        }
        this.leadingMinutiaeList = new MinutiaeList(this, this.internalNode.leadingMinutiae(), this.position());
        return this.leadingMinutiaeList;
    }

    public boolean containsTrailingMinutiae() {
        return this.internalNode.trailingMinutiae().bucketCount() > 0;
    }

    @Override
    public MinutiaeList trailingMinutiae() {
        if (this.trailingMinutiaeList != null) {
            return this.trailingMinutiaeList;
        }
        int trailingMinutiaeStartPos = this.position() + this.internalNode.widthWithLeadingMinutiae();
        this.trailingMinutiaeList = new MinutiaeList(this, this.internalNode.trailingMinutiae(), trailingMinutiaeStartPos);
        return this.trailingMinutiaeList;
    }

    public Token modify(MinutiaeList leadingMinutiae, MinutiaeList trailingMinutiae) {
        if (this.internalNode.leadingMinutiae() == leadingMinutiae.internalNode() && this.internalNode.trailingMinutiae() == trailingMinutiae.internalNode()) {
            return this;
        }
        return NodeFactory.createToken(this.kind(), leadingMinutiae, trailingMinutiae);
    }

    @Override
    public Iterable<Diagnostic> diagnostics() {
        if (!this.internalNode.hasDiagnostics()) {
            return Collections::emptyIterator;
        }
        return () -> this.collectDiagnostics().iterator();
    }

    private List<Diagnostic> collectDiagnostics() {
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
        this.leadingInvalidTokens().forEach(token -> token.diagnostics().forEach(diagnosticList::add));
        this.trailingInvalidTokens().forEach(token -> token.diagnostics().forEach(diagnosticList::add));
        for (STNodeDiagnostic stNodeDiagnostic : this.internalNode.diagnostics()) {
            Diagnostic syntaxDiagnostic = this.createSyntaxDiagnostic(stNodeDiagnostic);
            diagnosticList.add(syntaxDiagnostic);
        }
        return diagnosticList;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }
}

