/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeCastParamNode;
import java.util.Objects;

public class TypeCastExpressionNode
extends ExpressionNode {
    public TypeCastExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public TypeCastParamNode typeCastParam() {
        return (TypeCastParamNode)this.childInBucket(1);
    }

    public Token gtToken() {
        return (Token)this.childInBucket(2);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "typeCastParam", "gtToken", "expression"};
    }

    public TypeCastExpressionNode modify(Token ltToken, TypeCastParamNode typeCastParam, Token gtToken, ExpressionNode expression) {
        if (this.checkForReferenceEquality(ltToken, typeCastParam, gtToken, expression)) {
            return this;
        }
        return NodeFactory.createTypeCastExpressionNode(ltToken, typeCastParam, gtToken, expression);
    }

    public TypeCastExpressionNodeModifier modify() {
        return new TypeCastExpressionNodeModifier(this);
    }

    public static class TypeCastExpressionNodeModifier {
        private final TypeCastExpressionNode oldNode;
        private Token ltToken;
        private TypeCastParamNode typeCastParam;
        private Token gtToken;
        private ExpressionNode expression;

        public TypeCastExpressionNodeModifier(TypeCastExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.typeCastParam = oldNode.typeCastParam();
            this.gtToken = oldNode.gtToken();
            this.expression = oldNode.expression();
        }

        public TypeCastExpressionNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public TypeCastExpressionNodeModifier withTypeCastParam(TypeCastParamNode typeCastParam) {
            Objects.requireNonNull(typeCastParam, "typeCastParam must not be null");
            this.typeCastParam = typeCastParam;
            return this;
        }

        public TypeCastExpressionNodeModifier withGtToken(Token gtToken) {
            Objects.requireNonNull(gtToken, "gtToken must not be null");
            this.gtToken = gtToken;
            return this;
        }

        public TypeCastExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public TypeCastExpressionNode apply() {
            return this.oldNode.modify(this.ltToken, this.typeCastParam, this.gtToken, this.expression);
        }
    }
}

