/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class TypeParameterNode
extends NonTerminalNode {
    public TypeParameterNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public TypeDescriptorNode typeNode() {
        return (TypeDescriptorNode)this.childInBucket(1);
    }

    public Token gtToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "typeNode", "gtToken"};
    }

    public TypeParameterNode modify(Token ltToken, TypeDescriptorNode typeNode, Token gtToken) {
        if (this.checkForReferenceEquality(ltToken, typeNode, gtToken)) {
            return this;
        }
        return NodeFactory.createTypeParameterNode(ltToken, typeNode, gtToken);
    }

    public TypeParameterNodeModifier modify() {
        return new TypeParameterNodeModifier(this);
    }

    public static class TypeParameterNodeModifier {
        private final TypeParameterNode oldNode;
        private Token ltToken;
        private TypeDescriptorNode typeNode;
        private Token gtToken;

        public TypeParameterNodeModifier(TypeParameterNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.typeNode = oldNode.typeNode();
            this.gtToken = oldNode.gtToken();
        }

        public TypeParameterNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public TypeParameterNodeModifier withTypeNode(TypeDescriptorNode typeNode) {
            Objects.requireNonNull(typeNode, "typeNode must not be null");
            this.typeNode = typeNode;
            return this;
        }

        public TypeParameterNodeModifier withGtToken(Token gtToken) {
            Objects.requireNonNull(gtToken, "gtToken must not be null");
            this.gtToken = gtToken;
            return this;
        }

        public TypeParameterNode apply() {
            return this.oldNode.modify(this.ltToken, this.typeNode, this.gtToken);
        }
    }
}

