/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class XMLAttributeValue
extends NonTerminalNode {
    public XMLAttributeValue(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token startQuote() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<Node> value() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token endQuote() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startQuote", "value", "endQuote"};
    }

    public XMLAttributeValue modify(Token startQuote, NodeList<Node> value, Token endQuote) {
        if (this.checkForReferenceEquality(startQuote, value.underlyingListNode(), endQuote)) {
            return this;
        }
        return NodeFactory.createXMLAttributeValue(startQuote, value, endQuote);
    }

    public XMLAttributeValueModifier modify() {
        return new XMLAttributeValueModifier(this);
    }

    public static class XMLAttributeValueModifier {
        private final XMLAttributeValue oldNode;
        private Token startQuote;
        private NodeList<Node> value;
        private Token endQuote;

        public XMLAttributeValueModifier(XMLAttributeValue oldNode) {
            this.oldNode = oldNode;
            this.startQuote = oldNode.startQuote();
            this.value = oldNode.value();
            this.endQuote = oldNode.endQuote();
        }

        public XMLAttributeValueModifier withStartQuote(Token startQuote) {
            Objects.requireNonNull(startQuote, "startQuote must not be null");
            this.startQuote = startQuote;
            return this;
        }

        public XMLAttributeValueModifier withValue(NodeList<Node> value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
            return this;
        }

        public XMLAttributeValueModifier withEndQuote(Token endQuote) {
            Objects.requireNonNull(endQuote, "endQuote must not be null");
            this.endQuote = endQuote;
            return this;
        }

        public XMLAttributeValue apply() {
            return this.oldNode.modify(this.startQuote, this.value, this.endQuote);
        }
    }
}

