/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.XMLEndTagNode;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import io.ballerina.compiler.syntax.tree.XMLStartTagNode;
import java.util.Objects;

public class XMLElementNode
extends XMLItemNode {
    public XMLElementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public XMLStartTagNode startTag() {
        return (XMLStartTagNode)this.childInBucket(0);
    }

    public NodeList<XMLItemNode> content() {
        return new NodeList<XMLItemNode>((NonTerminalNode)this.childInBucket(1));
    }

    public XMLEndTagNode endTag() {
        return (XMLEndTagNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startTag", "content", "endTag"};
    }

    public XMLElementNode modify(XMLStartTagNode startTag, NodeList<XMLItemNode> content, XMLEndTagNode endTag) {
        if (this.checkForReferenceEquality(startTag, content.underlyingListNode(), endTag)) {
            return this;
        }
        return NodeFactory.createXMLElementNode(startTag, content, endTag);
    }

    public XMLElementNodeModifier modify() {
        return new XMLElementNodeModifier(this);
    }

    public static class XMLElementNodeModifier {
        private final XMLElementNode oldNode;
        private XMLStartTagNode startTag;
        private NodeList<XMLItemNode> content;
        private XMLEndTagNode endTag;

        public XMLElementNodeModifier(XMLElementNode oldNode) {
            this.oldNode = oldNode;
            this.startTag = oldNode.startTag();
            this.content = oldNode.content();
            this.endTag = oldNode.endTag();
        }

        public XMLElementNodeModifier withStartTag(XMLStartTagNode startTag) {
            Objects.requireNonNull(startTag, "startTag must not be null");
            this.startTag = startTag;
            return this;
        }

        public XMLElementNodeModifier withContent(NodeList<XMLItemNode> content) {
            Objects.requireNonNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public XMLElementNodeModifier withEndTag(XMLEndTagNode endTag) {
            Objects.requireNonNull(endTag, "endTag must not be null");
            this.endTag = endTag;
            return this;
        }

        public XMLElementNode apply() {
            return this.oldNode.modify(this.startTag, this.content, this.endTag);
        }
    }
}

