/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyEntryNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.KeyNode;
import java.util.ArrayList;
import java.util.List;

public class TomlKeyNode
extends TomlNode {
    private final List<TomlKeyEntryNode> keys;

    public TomlKeyNode(KeyNode node, List<TomlKeyEntryNode> keys, TomlNodeLocation location) {
        super(node, TomlType.KEY_VALUE, location);
        this.keys = keys;
    }

    public List<TomlKeyEntryNode> keys() {
        return this.keys;
    }

    public String name() {
        ArrayList<Object> list = new ArrayList<Object>(this.keys.size());
        for (TomlKeyEntryNode keyEntryNode : this.keys) {
            if (keyEntryNode.kind() == TomlType.STRING) {
                list.add("\"" + keyEntryNode.name().toString() + "\"");
                continue;
            }
            list.add(keyEntryNode.name().toString());
        }
        return String.join((CharSequence)".", list);
    }

    public String toString() {
        return "TomlKeyNode{keys=" + this.name() + "}";
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }
}

