/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.identifier.Utils;
import io.ballerina.toml.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBasicValueNode;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlDoubleValueNodeNode;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyEntryNode;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlUnquotedKeyNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.DiagnosticLog;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.BoolLiteralNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierLiteralNode;
import io.ballerina.toml.syntax.tree.InlineTableNode;
import io.ballerina.toml.syntax.tree.KeyNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.LiteralStringLiteralNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TomlTransformer
extends NodeTransformer<TomlNode> {
    private final DiagnosticLog dlog = DiagnosticLog.getInstance();

    @Override
    public TomlNode transform(DocumentNode documentNode) {
        TomlTableNode rootTable = this.createRootTable(documentNode);
        NodeList<DocumentMemberDeclarationNode> members = documentNode.members();
        block5: for (DocumentMemberDeclarationNode rootNode : members) {
            TomlNode transformedChild = rootNode.apply(this);
            switch (transformedChild.kind()) {
                case TABLE: {
                    TomlTableNode tableChild = (TomlTableNode)transformedChild;
                    this.addChildTableToParent(rootTable, tableChild);
                    continue block5;
                }
                case TABLE_ARRAY: {
                    TomlTableArrayNode transformedArray = (TomlTableArrayNode)transformedChild;
                    this.addChildParentArrayToParent(rootTable, transformedArray);
                    continue block5;
                }
                case KEY_VALUE: {
                    TomlKeyValueNode transformedKeyValuePair = (TomlKeyValueNode)transformedChild;
                    this.addChildKeyValueToParent(rootTable, transformedKeyValuePair);
                    continue block5;
                }
            }
            TomlDiagnostic unexpectedNode = this.dlog.error(transformedChild.location(), DiagnosticErrorCode.ERROR_UNEXPECTED_TOP_LEVEL_NODE, new Object[0]);
            rootTable.addDiagnostic(unexpectedNode);
        }
        return rootTable;
    }

    private TomlTableNode createRootTable(DocumentNode documentNode) {
        TomlNodeLocation location = this.getPosition(documentNode);
        IdentifierLiteralNode key = NodeFactory.createIdentifierLiteralNode(NodeFactory.createIdentifierToken("__root"));
        TomlKeyEntryNode root = new TomlKeyEntryNode(key, new TomlUnquotedKeyNode(key, "__root", location));
        List<TomlKeyEntryNode> tomlKeyEntryNodes = Collections.singletonList(root);
        TomlKeyNode tomlKeyNode = new TomlKeyNode(NodeFactory.createKeyNode(NodeFactory.createSeparatedNodeList(key)), tomlKeyEntryNodes, location);
        return new TomlTableNode(documentNode, tomlKeyNode, location);
    }

    private void addChildKeyValueToParent(TomlTableNode rootTable, TomlKeyValueNode transformedKeyValuePair) {
        List<TomlKeyEntryNode> keys = transformedKeyValuePair.key().keys();
        ArrayList<String> parentTables = new ArrayList<String>();
        for (int i = 0; i < keys.size() - 1; ++i) {
            parentTables.add(keys.get(i).name().toString());
        }
        TomlTableNode parentTable = rootTable;
        for (int i = 0; i < parentTables.size(); ++i) {
            String newTable = (String)parentTables.get(i);
            TopLevelNode dottedParentNode = parentTable.entries().get(newTable);
            if (dottedParentNode != null) {
                if (dottedParentNode.kind() == TomlType.TABLE) {
                    parentTable = (TomlTableNode)dottedParentNode;
                    continue;
                }
                TomlDiagnostic nodeExists = this.dlog.error(dottedParentNode.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE, newTable);
                parentTable.addDiagnostic(nodeExists);
                continue;
            }
            TomlKeyEntryNode tomlKeyEntryNode = keys.get(i);
            parentTable = this.createDottedKeyParentTable(parentTable, tomlKeyEntryNode, transformedKeyValuePair);
        }
        if (this.isDottedKey(keys)) {
            ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
            TomlKeyEntryNode childKeyEntry = keys.get(keys.size() - 1);
            list.add(childKeyEntry);
            TomlKeyNode newKey = new TomlKeyNode((KeyNode)transformedKeyValuePair.key().externalTreeNode(), list, childKeyEntry.location());
            transformedKeyValuePair = new TomlKeyValueNode((KeyValueNode)transformedKeyValuePair.externalTreeNode(), newKey, transformedKeyValuePair.value(), transformedKeyValuePair.location());
        }
        this.addChildToTableAST(parentTable, transformedKeyValuePair);
    }

    private void addChildToTableAST(TomlTableNode parentTable, TopLevelNode value) {
        String key;
        Map<String, TopLevelNode> entries = parentTable.entries();
        if (entries.containsKey(key = value.key().name())) {
            TomlDiagnostic nodeExists = this.dlog.error(value.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE, key);
            parentTable.addDiagnostic(nodeExists);
        } else {
            entries.put(key, value);
        }
    }

    private TomlTableNode createDottedKeyParentTable(TomlTableNode parentTable, TomlKeyEntryNode dottedKey, TomlKeyValueNode keyValueNode) {
        ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
        list.add(dottedKey);
        TomlKeyNode newTableKey = new TomlKeyNode((KeyNode)keyValueNode.key().externalTreeNode(), list, dottedKey.location());
        TomlTableNode newTomlTableNode = new TomlTableNode((KeyValueNode)keyValueNode.externalTreeNode(), newTableKey, keyValueNode.location());
        this.addChildToTableAST(parentTable, newTomlTableNode);
        return newTomlTableNode;
    }

    private void addChildParentArrayToParent(TomlTableNode rootTable, TomlTableArrayNode tableArrayChild) {
        TomlTableNode parentTable = this.getParentTable(rootTable, tableArrayChild);
        List<TomlKeyEntryNode> keys = tableArrayChild.key().keys();
        TomlKeyEntryNode tomlKeyEntryNode = keys.get(keys.size() - 1);
        ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
        list.add(tomlKeyEntryNode);
        TomlTableArrayNode newTomlTableArray = new TomlTableArrayNode((TableArrayNode)tableArrayChild.externalTreeNode(), new TomlKeyNode((KeyNode)tableArrayChild.key().externalTreeNode(), list, tomlKeyEntryNode.location()), tableArrayChild.location(), tableArrayChild.children());
        TopLevelNode topLevelNode = parentTable.entries().get(newTomlTableArray.key().name());
        if (topLevelNode == null) {
            this.addChildToTableAST(parentTable, newTomlTableArray);
        } else if (topLevelNode.kind() == TomlType.TABLE_ARRAY) {
            ((TomlTableArrayNode)topLevelNode).addChild(newTomlTableArray.children().get(0));
        } else {
            TomlDiagnostic nodeExists = this.dlog.error(newTomlTableArray.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE, newTomlTableArray.key().name());
            parentTable.addDiagnostic(nodeExists);
        }
    }

    private TomlKeyEntryNode getLastKeyEntry(TopLevelNode childNode) {
        return childNode.key().keys().get(childNode.key().keys().size() - 1);
    }

    private TomlTableNode getParentTable(TomlTableNode rootTable, TopLevelNode childNode) {
        ArrayList<String> parentTables = new ArrayList<String>();
        for (int i = 0; i < childNode.key().keys().size() - 1; ++i) {
            parentTables.add(childNode.key().keys().get(i).name().toString());
        }
        TomlTableNode parentTable = rootTable;
        for (int i = 0; i < parentTables.size(); ++i) {
            String parentString = (String)parentTables.get(i);
            TopLevelNode rootTableNode = parentTable.entries().get(parentString);
            if (rootTableNode != null) {
                if (rootTableNode.kind() == TomlType.TABLE) {
                    parentTable = (TomlTableNode)rootTableNode;
                    continue;
                }
                if (rootTableNode.kind() != TomlType.TABLE_ARRAY) continue;
                TomlTableArrayNode arrayNode = (TomlTableArrayNode)rootTableNode;
                List<TomlTableNode> children = arrayNode.children();
                parentTable = children.get(children.size() - 1);
                continue;
            }
            TomlKeyEntryNode tomlKeyEntryNode = childNode.key().keys().get(i);
            parentTable = this.generateTable(parentTable, tomlKeyEntryNode, childNode);
        }
        return parentTable;
    }

    private void addChildTableToParent(TomlTableNode rootTable, TomlTableNode tableChild) {
        TomlTableNode parentTable = this.getParentTable(rootTable, tableChild);
        TopLevelNode topLevelNode = parentTable.entries().get(tableChild.key().name());
        TomlKeyEntryNode lastKeyEntry = this.getLastKeyEntry(tableChild);
        ArrayList<TomlKeyEntryNode> entries = new ArrayList<TomlKeyEntryNode>();
        entries.add(lastKeyEntry);
        TomlTableNode newTableNode = this.generateNewTable(tableChild, lastKeyEntry, entries);
        if (newTableNode == null) {
            TomlDiagnostic nodeExist = this.dlog.error(tableChild.location(), DiagnosticErrorCode.ERROR_UNEXPECTED_TOP_LEVEL_NODE, tableChild.key().name());
            tableChild.addDiagnostic(nodeExist);
            return;
        }
        if (topLevelNode == null) {
            this.addChildToTableAST(parentTable, newTableNode);
        } else if (topLevelNode.kind() == TomlType.TABLE) {
            TomlTableNode targetTable = (TomlTableNode)topLevelNode;
            if (targetTable.generated()) {
                parentTable.replaceGeneratedTable(newTableNode);
            } else {
                TomlDiagnostic nodeExists = this.dlog.error(tableChild.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE, newTableNode.key().name());
                parentTable.addDiagnostic(nodeExists);
            }
        } else {
            TomlDiagnostic nodeExist = this.dlog.error(newTableNode.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE, tableChild.key().name());
            parentTable.addDiagnostic(nodeExist);
        }
    }

    private TomlTableNode generateNewTable(TomlTableNode child, TomlKeyEntryNode lastKeyEntry, List<TomlKeyEntryNode> entries) {
        if (child.externalTreeNode().kind() == SyntaxKind.TABLE) {
            return new TomlTableNode((TableNode)child.externalTreeNode(), new TomlKeyNode((KeyNode)child.key().externalTreeNode(), entries, lastKeyEntry.location()), child.generated(), child.location(), child.entries());
        }
        if (child.externalTreeNode().kind() == SyntaxKind.KEY_VALUE) {
            return new TomlTableNode((KeyValueNode)child.externalTreeNode(), new TomlKeyNode((KeyNode)child.key().externalTreeNode(), entries, lastKeyEntry.location()), child.generated(), child.location(), child.entries());
        }
        return null;
    }

    private TomlTableNode generateTable(TomlTableNode parentTable, TomlKeyEntryNode parentString, TopLevelNode topLevelNode) {
        TomlNodeLocation location = topLevelNode.location();
        ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
        list.add(parentString);
        TomlKeyNode newTableKey = new TomlKeyNode((KeyNode)topLevelNode.key().externalTreeNode(), list, parentString.location());
        DocumentMemberDeclarationNode node = (DocumentMemberDeclarationNode)topLevelNode.externalTreeNode();
        TomlTableNode table = new TomlTableNode(node, newTableKey, true, location);
        this.addChildToTableAST(parentTable, table);
        return table;
    }

    @Override
    public TomlNode transform(TableNode tableNode) {
        TomlKeyNode tomlKeyNode = this.getTomlKeyNode(tableNode.identifier());
        TomlTableNode tomlTableNode = new TomlTableNode(tableNode, tomlKeyNode, this.getPosition(tableNode));
        this.addChildToTable(tableNode, tomlTableNode);
        return tomlTableNode;
    }

    private void addChildToTable(TableNode stTableNode, TomlTableNode astTomlTableNode) {
        NodeList<KeyValueNode> children = stTableNode.fields();
        for (KeyValueNode child : children) {
            TomlNode transformedChild = child.apply(this);
            TopLevelNode topLevelChild = (TopLevelNode)transformedChild;
            this.checkExistingNodes(astTomlTableNode, topLevelChild);
            if (transformedChild.kind() == TomlType.KEY_VALUE) {
                this.addChildKeyValueToParent(astTomlTableNode, (TomlKeyValueNode)transformedChild);
                continue;
            }
            if (transformedChild.kind() == TomlType.TABLE) {
                this.addChildTableToParent(astTomlTableNode, (TomlTableNode)transformedChild);
                continue;
            }
            TomlDiagnostic unexpectedNode = this.dlog.error(topLevelChild.location(), DiagnosticErrorCode.ERROR_UNEXPECTED_TOP_LEVEL_NODE, topLevelChild.key().name());
            astTomlTableNode.addDiagnostic(unexpectedNode);
        }
    }

    private boolean isDottedKey(List<TomlKeyEntryNode> keys) {
        return keys.size() > 1;
    }

    private void checkExistingNodes(TomlTableNode tomlTableNode, TopLevelNode topLevelChild) {
        String childName;
        Map<String, TopLevelNode> childs = tomlTableNode.entries();
        if (childs.get(childName = topLevelChild.key().name()) != null) {
            TomlDiagnostic nodeExists = this.dlog.error(topLevelChild.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE, childName);
            tomlTableNode.addDiagnostic(nodeExists);
        }
    }

    @Override
    public TomlNode transform(TableArrayNode tableArrayNode) {
        TomlKeyNode tomlKeyNode = this.getTomlKeyNode(tableArrayNode.identifier());
        TomlTableArrayNode tomlTableArrayNode = new TomlTableArrayNode(tableArrayNode, tomlKeyNode, this.getPosition(tableArrayNode));
        TomlTableNode anonTable = this.addChildsToTableArray(tableArrayNode);
        tomlTableArrayNode.addChild(anonTable);
        return tomlTableArrayNode;
    }

    private TomlTableNode addChildsToTableArray(TableArrayNode tableArrayNode) {
        NodeList<KeyValueNode> children = tableArrayNode.fields();
        TomlNodeLocation position = this.getPosition(tableArrayNode);
        TomlKeyNode anonKey = this.getTomlKeyNode(tableArrayNode.identifier());
        TomlTableNode anonTable = new TomlTableNode(tableArrayNode, anonKey, position);
        for (KeyValueNode child : children) {
            TomlNode transformedChild = child.apply(this);
            if (transformedChild.kind() == TomlType.KEY_VALUE) {
                this.addChildKeyValueToParent(anonTable, (TomlKeyValueNode)transformedChild);
                continue;
            }
            if (transformedChild.kind() == TomlType.TABLE) {
                this.addChildTableToParent(anonTable, (TomlTableNode)transformedChild);
                continue;
            }
            TomlDiagnostic unexpectedNode = this.dlog.error(anonTable.location(), DiagnosticErrorCode.ERROR_UNEXPECTED_TOP_LEVEL_NODE, anonTable.key().name());
            anonTable.addDiagnostic(unexpectedNode);
        }
        return anonTable;
    }

    @Override
    public TomlNode transform(KeyValueNode keyValue) {
        KeyNode identifier = keyValue.identifier();
        TomlKeyNode tomlKeyNode = this.getTomlKeyNode(identifier);
        ValueNode value = keyValue.value();
        TomlValueNode tomlValue = this.transformValue(value);
        if (tomlValue.externalTreeNode().kind() == SyntaxKind.INLINE_TABLE) {
            TomlInlineTableValueNode inlineTable = (TomlInlineTableValueNode)tomlValue;
            TomlTableNode tomlTableNode = new TomlTableNode(keyValue, tomlKeyNode, false, this.getPosition(keyValue));
            for (TopLevelNode element : inlineTable.elements()) {
                if (element.kind() == TomlType.KEY_VALUE) {
                    this.addChildKeyValueToParent(tomlTableNode, (TomlKeyValueNode)element);
                    continue;
                }
                if (element.kind() == TomlType.TABLE) {
                    this.addChildTableToParent(tomlTableNode, (TomlTableNode)element);
                    continue;
                }
                TomlDiagnostic unexpectedNode = this.dlog.error(tomlTableNode.location(), DiagnosticErrorCode.ERROR_UNEXPECTED_TOP_LEVEL_NODE, element.key().name());
                tomlTableNode.addDiagnostic(unexpectedNode);
            }
            return tomlTableNode;
        }
        return new TomlKeyValueNode(keyValue, tomlKeyNode, tomlValue, this.getPosition(keyValue));
    }

    private TomlKeyNode getTomlKeyNode(KeyNode identifier) {
        SeparatedNodeList<ValueNode> identifierList = identifier.value();
        ArrayList<TomlKeyEntryNode> nodeList = new ArrayList<TomlKeyEntryNode>();
        for (Node node : identifierList) {
            TomlBasicValueNode transformedNode = (TomlBasicValueNode)node.apply(this);
            nodeList.add(new TomlKeyEntryNode((ValueNode)node, transformedNode));
        }
        return new TomlKeyNode(identifier, nodeList, this.getTomlNodeListLocation(nodeList));
    }

    private TomlValueNode transformValue(ValueNode valueToken) {
        return (TomlValueNode)valueToken.apply(this);
    }

    @Override
    public TomlNode transform(ArrayNode array) {
        SeparatedNodeList<ValueNode> values = array.value();
        ArrayList<TomlValueNode> elements = new ArrayList<TomlValueNode>();
        for (ValueNode value : values) {
            TomlValueNode transformedValue = (TomlValueNode)value.apply(this);
            elements.add(transformedValue);
        }
        return new TomlArrayValueNode(array, elements, this.getPosition(array));
    }

    @Override
    protected TomlNode transformSyntaxNode(Node node) {
        return null;
    }

    private TomlNodeLocation getPosition(Node node) {
        return new TomlNodeLocation(node.lineRange(), node.textRange());
    }

    @Override
    public TomlNode transform(StringLiteralNode stringLiteralNode) {
        String valueString;
        boolean multilineString = this.isMultilineString(stringLiteralNode.startDoubleQuote());
        Optional<Token> content = stringLiteralNode.content();
        if (content.isEmpty()) {
            valueString = "";
        } else {
            valueString = content.get().text();
            if (multilineString) {
                valueString = this.removeFirstNewline(valueString);
                valueString = this.trimBackslashWhitespaces(valueString);
            }
        }
        String unescapedJava = Utils.unescapeJava(valueString);
        TomlNodeLocation position = this.getPosition(stringLiteralNode);
        return new TomlStringValueNode(stringLiteralNode, unescapedJava, position);
    }

    private String trimBackslashWhitespaces(String value) {
        String[] split;
        StringBuilder output = new StringBuilder();
        for (String str : split = value.split("\\\\\\r?\\n")) {
            output.append(str.stripLeading());
        }
        return output.toString();
    }

    @Override
    public TomlNode transform(LiteralStringLiteralNode literalStringLiteralNode) {
        String valueString;
        boolean multilineString = this.isMultilineString(literalStringLiteralNode.startSingleQuote());
        Optional<Token> content = literalStringLiteralNode.content();
        if (content.isEmpty()) {
            valueString = "";
        } else {
            valueString = content.get().text();
            if (multilineString) {
                valueString = this.removeFirstNewline(valueString);
            }
        }
        TomlNodeLocation position = this.getPosition(literalStringLiteralNode);
        return new TomlStringValueNode(literalStringLiteralNode, valueString, position);
    }

    private boolean isMultilineString(Token token) {
        return token.kind() == SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN || token.kind() == SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN;
    }

    private String removeFirstNewline(String value) {
        if (value.startsWith("\n")) {
            return value.substring(1);
        }
        if (value.startsWith("\r\n")) {
            return value.substring(2);
        }
        return value;
    }

    @Override
    public TomlNode transform(NumericLiteralNode numericLiteralNode) {
        String sign = "";
        if (numericLiteralNode.sign().isPresent()) {
            sign = numericLiteralNode.sign().get().text();
        }
        Token valueToken = numericLiteralNode.value();
        return this.getTomlNode(numericLiteralNode, sign + valueToken.text());
    }

    private TomlNode getTomlNode(NumericLiteralNode numericLiteralNode, String value) {
        value = value.replace("_", "");
        if (numericLiteralNode.kind() == SyntaxKind.DEC_INT) {
            return new TomlLongValueNode(numericLiteralNode, Long.parseLong(value), this.getPosition(numericLiteralNode));
        }
        if (numericLiteralNode.kind() == SyntaxKind.HEX_INT) {
            value = value.replace("0x", "").replace("0X", "");
            return new TomlLongValueNode(numericLiteralNode, Long.parseLong(value, 16), this.getPosition(numericLiteralNode));
        }
        if (numericLiteralNode.kind() == SyntaxKind.OCT_INT) {
            value = value.replace("0o", "").replace("0O", "");
            return new TomlLongValueNode(numericLiteralNode, Long.parseLong(value, 8), this.getPosition(numericLiteralNode));
        }
        if (numericLiteralNode.kind() == SyntaxKind.BINARY_INT) {
            value = value.replace("0b", "").replace("0B", "");
            return new TomlLongValueNode(numericLiteralNode, Long.parseLong(value, 2), this.getPosition(numericLiteralNode));
        }
        return new TomlDoubleValueNodeNode(numericLiteralNode, Double.parseDouble(value), this.getPosition(numericLiteralNode));
    }

    @Override
    public TomlNode transform(BoolLiteralNode boolLiteralNode) {
        if (boolLiteralNode.value().kind() == SyntaxKind.TRUE_KEYWORD) {
            return new TomlBooleanValueNode(boolLiteralNode, true, this.getPosition(boolLiteralNode));
        }
        return new TomlBooleanValueNode(boolLiteralNode, false, this.getPosition(boolLiteralNode));
    }

    @Override
    public TomlNode transform(IdentifierLiteralNode identifierLiteralNode) {
        return new TomlUnquotedKeyNode(identifierLiteralNode, identifierLiteralNode.value().text(), this.getPosition(identifierLiteralNode));
    }

    @Override
    public TomlNode transform(InlineTableNode inlineTableNode) {
        SeparatedNodeList<KeyValueNode> values = inlineTableNode.values();
        ArrayList<TopLevelNode> elements = new ArrayList<TopLevelNode>();
        for (KeyValueNode value : values) {
            TopLevelNode transformedValue = (TopLevelNode)value.apply(this);
            elements.add(transformedValue);
        }
        return new TomlInlineTableValueNode(inlineTableNode, elements, this.getPosition(inlineTableNode));
    }

    private TomlNodeLocation getTomlNodeListLocation(List<? extends TomlNode> tomlNodes) {
        if (tomlNodes.isEmpty()) {
            return null;
        }
        TomlNode firstNode = tomlNodes.get(0);
        if (tomlNodes.size() == 1) {
            return firstNode.location();
        }
        TomlNodeLocation firstKeyLocation = firstNode.location();
        int length = 0;
        for (TomlNode tomlNode : tomlNodes) {
            length += tomlNode.location().textRange().length() + 1;
        }
        TextRange textRange = TextRange.from(firstKeyLocation.textRange().startOffset(), length - 1);
        LineRange lineRange = LineRange.from(firstKeyLocation.lineRange().fileName(), firstKeyLocation.lineRange().startLine(), tomlNodes.get(tomlNodes.size() - 1).location().lineRange().endLine());
        return new TomlNodeLocation(lineRange, textRange);
    }
}

