/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class InlineTableNode
extends ValueNode {
    public InlineTableNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<KeyValueNode> values() {
        return new SeparatedNodeList<KeyValueNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBrace", "values", "closeBrace"};
    }

    public InlineTableNode modify(Token openBrace, SeparatedNodeList<KeyValueNode> values, Token closeBrace) {
        if (this.checkForReferenceEquality(openBrace, values.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createInlineTableNode(openBrace, values, closeBrace);
    }

    public InlineTableNodeModifier modify() {
        return new InlineTableNodeModifier(this);
    }

    public static class InlineTableNodeModifier {
        private final InlineTableNode oldNode;
        private Token openBrace;
        private SeparatedNodeList<KeyValueNode> values;
        private Token closeBrace;

        public InlineTableNodeModifier(InlineTableNode oldNode) {
            this.oldNode = oldNode;
            this.openBrace = oldNode.openBrace();
            this.values = oldNode.values();
            this.closeBrace = oldNode.closeBrace();
        }

        public InlineTableNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public InlineTableNodeModifier withValues(SeparatedNodeList<KeyValueNode> values) {
            Objects.requireNonNull(values, "values must not be null");
            this.values = values;
            return this;
        }

        public InlineTableNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public InlineTableNode apply() {
            return this.oldNode.modify(this.openBrace, this.values, this.closeBrace);
        }
    }
}

