/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.url.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.url.UrlUtils;
import java.net.URLEncoder;

public final class Encode {
    private Encode() {
    }

    public static Object encode(BString str, BString charset) {
        try {
            String encoded = URLEncoder.encode(str.getValue(), charset.getValue());
            StringBuilder buf = new StringBuilder(encoded.length());
            for (int i = 0; i < encoded.length(); ++i) {
                char focus = encoded.charAt(i);
                if (focus == '*') {
                    buf.append("%2A");
                    continue;
                }
                if (focus == '+') {
                    buf.append("%20");
                    continue;
                }
                if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                    buf.append('~');
                    i += 2;
                    continue;
                }
                buf.append(focus);
            }
            return StringUtils.fromString((String)buf.toString());
        }
        catch (Throwable e) {
            return UrlUtils.createError("Error occurred while encoding. " + e.getMessage());
        }
    }
}

