/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.FunctionContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CryptoAnalyzerUtils {
    private static final String BALLERINA_ORG = "ballerina";
    private static final String CRYPTO = "crypto";

    private CryptoAnalyzerUtils() {
    }

    public static Optional<FunctionSymbol> getCryptoFunctionSymbol(FunctionCallExpressionNode functionCall, SemanticModel semanticModel) {
        FunctionSymbol functionSymbol;
        Object t;
        Optional functionCallSymbolOptional = semanticModel.symbol((Node)functionCall);
        if (functionCallSymbolOptional.isEmpty() || !((t = functionCallSymbolOptional.get()) instanceof FunctionSymbol) || (functionSymbol = (FunctionSymbol)t).getModule().isEmpty()) {
            return Optional.empty();
        }
        ModuleID moduleId = ((ModuleSymbol)((Symbol)functionCallSymbolOptional.get()).getModule().get()).id();
        if (BALLERINA_ORG.equals(moduleId.orgName()) && CRYPTO.equals(moduleId.packageName())) {
            return Optional.of(functionSymbol);
        }
        return Optional.empty();
    }

    public static Document getDocument(Module module, DocumentId documentId) {
        return module.document(documentId);
    }

    public static String unescapeIdentifier(String identifierName) {
        String result = identifierName;
        if (result.startsWith("'")) {
            result = result.substring(1);
        }
        return result.replace("\\\\", "");
    }

    public static Map<String, ExpressionNode> getParamExpressions(List<ParameterSymbol> params, SeparatedNodeList<FunctionArgumentNode> arguments) {
        HashMap<String, ExpressionNode> paramExpressions = new HashMap<String, ExpressionNode>();
        List<String> paramNames = params.stream().map(ParameterSymbol::getName).filter(Optional::isPresent).map(Optional::get).map(CryptoAnalyzerUtils::unescapeIdentifier).toList();
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionNode expression;
            String paramName;
            FunctionArgumentNode argument = (FunctionArgumentNode)arguments.get(i);
            if (argument instanceof PositionalArgumentNode) {
                PositionalArgumentNode positionalArg = (PositionalArgumentNode)argument;
                if (i >= paramNames.size()) continue;
                paramName = paramNames.get(i);
                paramName = CryptoAnalyzerUtils.unescapeIdentifier(paramName);
                expression = positionalArg.expression();
                paramExpressions.put(paramName, expression);
                continue;
            }
            if (!(argument instanceof NamedArgumentNode)) continue;
            NamedArgumentNode namedArg = (NamedArgumentNode)argument;
            paramName = namedArg.argumentName().name().text();
            paramName = CryptoAnalyzerUtils.unescapeIdentifier(paramName);
            expression = namedArg.expression();
            paramExpressions.put(paramName, expression);
        }
        return paramExpressions;
    }

    public static Optional<StatementNode> getStatementNode(FunctionCallExpressionNode functionCall) {
        NonTerminalNode parent = functionCall.parent();
        if (parent.kind().equals((Object)SyntaxKind.CHECK_EXPRESSION)) {
            parent = parent.parent();
        }
        if (parent instanceof StatementNode) {
            StatementNode statementNode = (StatementNode)parent;
            return Optional.of(statementNode);
        }
        return Optional.empty();
    }

    public static Optional<Node> getParentBlockNode(Node node) {
        NonTerminalNode parent;
        NonTerminalNode nonTerminalNode = parent = node.parent();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FunctionBodyBlockNode.class, BlockStatementNode.class}, (Object)nonTerminalNode, n)) {
            case -1 -> Optional.empty();
            case 0 -> {
                FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)nonTerminalNode;
                yield Optional.of(functionBody);
            }
            case 1 -> {
                BlockStatementNode blockStatementNode = (BlockStatementNode)nonTerminalNode;
                yield Optional.of(blockStatementNode);
            }
            default -> CryptoAnalyzerUtils.getParentBlockNode((Node)parent);
        };
    }

    public static Optional<ModulePartNode> getModulePartNode(Node node) {
        NonTerminalNode parent;
        NonTerminalNode nonTerminalNode = parent = node.parent();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModulePartNode.class}, (Object)nonTerminalNode, n)) {
            case -1 -> Optional.empty();
            case 0 -> {
                ModulePartNode modulePartNode = (ModulePartNode)nonTerminalNode;
                yield Optional.of(modulePartNode);
            }
            default -> CryptoAnalyzerUtils.getModulePartNode((Node)parent);
        };
    }

    public static Map<String, ExpressionNode> getModuleLevelVarExpressions(ModulePartNode modulePartNode) {
        HashMap<String, ExpressionNode> varExpressions = new HashMap<String, ExpressionNode>();
        for (ModuleMemberDeclarationNode member : modulePartNode.members()) {
            if (!(member instanceof ModuleVariableDeclarationNode)) continue;
            ModuleVariableDeclarationNode variableDeclarationNode = (ModuleVariableDeclarationNode)member;
            BindingPatternNode bindingPatternNode = variableDeclarationNode.typedBindingPattern().bindingPattern();
            if (variableDeclarationNode.initializer().isEmpty() || !(bindingPatternNode instanceof CaptureBindingPatternNode)) continue;
            CaptureBindingPatternNode captureBindingPattern = (CaptureBindingPatternNode)bindingPatternNode;
            String varName = captureBindingPattern.variableName().text();
            varName = CryptoAnalyzerUtils.unescapeIdentifier(varName);
            ExpressionNode initializer = (ExpressionNode)variableDeclarationNode.initializer().get();
            varExpressions.put(varName, initializer);
        }
        return varExpressions;
    }

    public static void collectVariableExpressionsUntilStatement(Node blockNode, StatementNode statementNode, Map<String, ExpressionNode> varExpressions) {
        Node node = blockNode;
        Objects.requireNonNull(node);
        Node node2 = node;
        int n = 0;
        NodeList statements = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FunctionBodyBlockNode.class, BlockStatementNode.class}, (Object)node2, n)) {
            case 0 -> {
                FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)node2;
                yield functionBody.statements();
            }
            case 1 -> {
                BlockStatementNode blockStatementNode = (BlockStatementNode)node2;
                yield blockStatementNode.statements();
            }
            default -> throw new IllegalArgumentException("Unsupported block node type: " + String.valueOf(blockNode.kind()));
        };
        CryptoAnalyzerUtils.processStatementsForVariableExpressions((NodeList<StatementNode>)statements, statementNode, varExpressions);
    }

    public static boolean isBlockStatementNode(StatementNode statement) {
        SyntaxKind kind = statement.kind();
        return kind.equals((Object)SyntaxKind.BLOCK_STATEMENT) || kind.equals((Object)SyntaxKind.DO_STATEMENT) || kind.equals((Object)SyntaxKind.FORK_STATEMENT) || kind.equals((Object)SyntaxKind.IF_ELSE_STATEMENT) || kind.equals((Object)SyntaxKind.LOCK_STATEMENT) || kind.equals((Object)SyntaxKind.MATCH_STATEMENT) || kind.equals((Object)SyntaxKind.FOREACH_STATEMENT) || kind.equals((Object)SyntaxKind.WHILE_STATEMENT) || kind.equals((Object)SyntaxKind.TRANSACTION_STATEMENT) || kind.equals((Object)SyntaxKind.RETRY_STATEMENT);
    }

    public static Optional<String> getStringValue(String key, FunctionContext context) {
        Optional<ExpressionNode> valueExprOpt = context.getParamExpression(key);
        if (valueExprOpt.isEmpty()) {
            return Optional.empty();
        }
        ExpressionNode valueExpr = valueExprOpt.get();
        if (valueExpr.kind().equals((Object)SyntaxKind.STRING_LITERAL)) {
            String stringValue = ((BasicLiteralNode)valueExpr).literalToken().text();
            stringValue = stringValue.substring(1, stringValue.length() - 1);
            return Optional.of(stringValue);
        }
        if (valueExpr instanceof NameReferenceNode) {
            ConstantValue constantValue;
            ConstantSymbol constantRef;
            Object object;
            NameReferenceNode refNode = (NameReferenceNode)valueExpr;
            Optional refSymbol = context.semanticModel().symbol((Node)refNode);
            if (refSymbol.isPresent() && (object = refSymbol.get()) instanceof ConstantSymbol && (object = (constantRef = (ConstantSymbol)object).constValue()) instanceof ConstantValue && (object = (constantValue = (ConstantValue)object).value()) instanceof String) {
                String constString = (String)object;
                return Optional.of(constString);
            }
        }
        return Optional.empty();
    }

    public static void processStatementsForVariableExpressions(NodeList<StatementNode> statements, StatementNode targetStatement, Map<String, ExpressionNode> varExpressions) {
        for (StatementNode statement : statements) {
            boolean isBlockStatement = CryptoAnalyzerUtils.isBlockStatementNode(statement);
            if (statement.equals(targetStatement) || isBlockStatement) {
                if (!isBlockStatement) break;
                varExpressions.clear();
                break;
            }
            if (statement instanceof AssignmentStatementNode) {
                AssignmentStatementNode assignmentNode = (AssignmentStatementNode)statement;
                CryptoAnalyzerUtils.processAssignmentStatement(assignmentNode, varExpressions);
                continue;
            }
            if (!(statement instanceof VariableDeclarationNode)) continue;
            VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)statement;
            CryptoAnalyzerUtils.processVariableDeclaration(variableDeclarationNode, varExpressions);
        }
    }

    private static void processAssignmentStatement(AssignmentStatementNode assignmentNode, Map<String, ExpressionNode> varExpressions) {
        Node varRef = assignmentNode.varRef();
        if (varRef instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)varRef;
            String varName = CryptoAnalyzerUtils.unescapeIdentifier(simpleNameRef.name().text());
            ExpressionNode expression = assignmentNode.expression();
            varExpressions.put(varName, expression);
        }
    }

    private static void processVariableDeclaration(VariableDeclarationNode variableDeclarationNode, Map<String, ExpressionNode> varExpressions) {
        BindingPatternNode bindingPatternNode = variableDeclarationNode.typedBindingPattern().bindingPattern();
        if (variableDeclarationNode.initializer().isEmpty() || !(bindingPatternNode instanceof CaptureBindingPatternNode)) {
            return;
        }
        CaptureBindingPatternNode captureBindingPattern = (CaptureBindingPatternNode)bindingPatternNode;
        String varName = CryptoAnalyzerUtils.unescapeIdentifier(captureBindingPattern.variableName().text());
        ExpressionNode initializer = (ExpressionNode)variableDeclarationNode.initializer().get();
        varExpressions.put(varName, initializer);
    }
}

