/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoAnalyzerUtils;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoFunctionRulesEngine;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.FunctionContext;
import java.util.Optional;

public class CryptoCipherAlgorithmAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;
    private final CryptoFunctionRulesEngine rulesEngine;

    public CryptoCipherAlgorithmAnalyzer(Reporter reporter) {
        this.reporter = reporter;
        this.rulesEngine = new CryptoFunctionRulesEngine();
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)context.node();
        SemanticModel semanticModel = context.semanticModel();
        Document document = CryptoAnalyzerUtils.getDocument(context.currentPackage().module(context.moduleId()), context.documentId());
        if (!functionCall.functionName().kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
            return;
        }
        Optional<FunctionSymbol> functionSymbolOpt = CryptoAnalyzerUtils.getCryptoFunctionSymbol(functionCall, semanticModel);
        if (functionSymbolOpt.isEmpty()) {
            return;
        }
        FunctionContext functionContext = FunctionContext.getInstance(semanticModel, this.reporter, document, functionCall, functionSymbolOpt.get());
        this.rulesEngine.executeRules(functionContext);
    }
}

