/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer;

import io.ballerina.scan.Rule;
import io.ballerina.scan.RuleKind;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.RuleFactory;

public enum CryptoRule {
    AVOID_WEAK_CIPHER_ALGORITHMS(RuleFactory.createRule(1, "Avoid using insecure cipher modes or padding schemes", RuleKind.VULNERABILITY)),
    AVOID_FAST_HASH_ALGORITHMS(RuleFactory.createRule(2, "Avoid using fast hashing algorithms", RuleKind.VULNERABILITY)),
    AVOID_REUSING_COUNTER_MODE_VECTORS(RuleFactory.createRule(3, "Avoid reusing counter mode initialization vectors", RuleKind.VULNERABILITY));

    private final Rule rule;

    private CryptoRule(Rule rule) {
        this.rule = rule;
    }

    public int getId() {
        return this.rule.numericId();
    }

    public String getDescription() {
        return this.rule.description();
    }

    public String toString() {
        return "{\"id\":" + this.getId() + ", \"kind\":\"" + String.valueOf(this.rule.kind()) + "\", \"description\" : \"" + this.rule.description() + "\"}";
    }
}

