/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoAnalyzerUtils;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.CryptoRule;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.FunctionContext;
import io.ballerina.stdlib.crypto.compiler.staticcodeanalyzer.functionrules.CryptoFunctionRule;
import java.util.Optional;

public class AvoidReusingCounterModeVectorsRule
implements CryptoFunctionRule {
    public static final String ENCRYPT_AES_CBC = "encryptAesCbc";
    public static final String ENCRYPT_AES_GCM = "encryptAesGcm";
    public static final String INITIALIZATION_VECTOR = "iv";
    public static final String TO_BYTES_METHOD = "toBytes";

    @Override
    public void analyze(FunctionContext context) {
        Optional<ExpressionNode> paramExpression = context.getParamExpression(INITIALIZATION_VECTOR);
        if (paramExpression.isEmpty()) {
            throw new IllegalStateException("Initialization vector parameter is missing for function: " + context.functionName());
        }
        if (this.hasHardCodedIV(paramExpression.get(), context)) {
            context.reporter().reportIssue(context.document(), context.functionLocation(), this.getRuleId());
        }
    }

    @Override
    public int getRuleId() {
        return CryptoRule.AVOID_REUSING_COUNTER_MODE_VECTORS.getId();
    }

    @Override
    public boolean isApplicable(FunctionContext context) {
        String functionName = context.functionName();
        return functionName.equals(ENCRYPT_AES_CBC) || functionName.equals(ENCRYPT_AES_GCM);
    }

    private boolean hasHardCodedIV(ExpressionNode ivExpression, FunctionContext context) {
        if (ivExpression instanceof ListConstructorExpressionNode) {
            ListConstructorExpressionNode listExpression = (ListConstructorExpressionNode)ivExpression;
            return listExpression.expressions().stream().allMatch(expr -> expr.kind().equals((Object)SyntaxKind.NUMERIC_LITERAL));
        }
        if (ivExpression instanceof MethodCallExpressionNode) {
            MethodCallExpressionNode methodCallExpression = (MethodCallExpressionNode)ivExpression;
            ExpressionNode expression = methodCallExpression.expression();
            if (!this.isMethodCallOnConstantExpr(expression, context)) {
                return false;
            }
            NameReferenceNode nameReferenceNode = methodCallExpression.methodName();
            if (nameReferenceNode instanceof SimpleNameReferenceNode) {
                SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)nameReferenceNode;
                return simpleNameRef.name().text().equals(TO_BYTES_METHOD);
            }
        }
        return false;
    }

    private boolean isMethodCallOnConstantExpr(ExpressionNode expression, FunctionContext context) {
        Optional symbol;
        if (expression.kind().equals((Object)SyntaxKind.STRING_LITERAL)) {
            return true;
        }
        if ((expression.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE) || expression.kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) && (symbol = context.semanticModel().symbol((Node)expression)).isPresent() && ((Symbol)symbol.get()).kind().equals((Object)SymbolKind.CONSTANT)) {
            return true;
        }
        if (expression instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)expression;
            String varName = CryptoAnalyzerUtils.unescapeIdentifier(simpleNameRef.name().text());
            Optional<ExpressionNode> paramExpression = context.getVarExpression(varName);
            return paramExpression.isPresent() && this.isMethodCallOnConstantExpr(paramExpression.get(), context);
        }
        return false;
    }
}

