/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphqlmodelgenerator.core;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.graphqlmodelgenerator.core.model.Interaction;
import io.ballerina.graphqlmodelgenerator.core.model.Param;
import io.ballerina.graphqlmodelgenerator.core.model.RemoteFunction;
import io.ballerina.graphqlmodelgenerator.core.model.ResourceFunction;
import io.ballerina.graphqlmodelgenerator.core.model.Service;
import io.ballerina.graphqlmodelgenerator.core.utils.ModelGenerationUtils;
import io.ballerina.stdlib.graphql.commons.types.LinePosition;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;

public class ServiceModelGenerator {
    private final Schema schemaObj;
    private final String serviceName;
    private final List<ResourceFunction> resourceFunctions;
    private final List<RemoteFunction> remoteFunctions;
    private final LineRange servicePosition;
    private final SyntaxTree syntaxTree;

    public ServiceModelGenerator(Schema schema, String serviceName, LineRange servicePosition, SyntaxTree syntaxTree) {
        this.schemaObj = schema;
        this.serviceName = serviceName;
        this.resourceFunctions = new ArrayList<ResourceFunction>();
        this.remoteFunctions = new ArrayList<RemoteFunction>();
        this.servicePosition = servicePosition;
        this.syntaxTree = syntaxTree;
    }

    public Service generate() {
        this.generateGraphqlOperation(this.schemaObj.getQueryType(), OperationKind.QUERY);
        this.generateGraphqlOperation(this.schemaObj.getMutationType(), OperationKind.MUTATION);
        this.generateGraphqlOperation(this.schemaObj.getSubscriptionType(), OperationKind.SUBSCRIPTION);
        Position nodePosition = new Position(this.servicePosition.fileName(), new LinePosition(this.servicePosition.startLine().line(), this.servicePosition.startLine().offset()), new LinePosition(this.servicePosition.endLine().line(), this.servicePosition.endLine().offset()));
        return new Service(this.serviceName, nodePosition, this.schemaObj.getDescription(), this.resourceFunctions, this.remoteFunctions);
    }

    private void generateGraphqlOperation(Type operation, OperationKind operationKind) {
        if (operation != null) {
            operation.getFields().forEach(field -> {
                String returns = ModelGenerationUtils.getFormattedFieldType(field.getType());
                List<Interaction> links = ModelGenerationUtils.getInteractionList(field);
                ArrayList<Param> params = new ArrayList<Param>();
                field.getArgs().forEach(inputValue -> {
                    String inputObj;
                    Param param = new Param(ModelGenerationUtils.createArgType(inputValue), inputValue.getName(), inputValue.getDescription(), inputValue.getDefaultValue());
                    params.add(param);
                    Type paramType = ModelGenerationUtils.getType(inputValue.getType());
                    if (paramType.getKind().equals((Object)TypeKind.INPUT_OBJECT) && (inputObj = ModelGenerationUtils.getFieldType(paramType)) != null) {
                        links.add(new Interaction(inputObj, ModelGenerationUtils.getPathOfFieldType(paramType)));
                    }
                });
                Position position = ModelGenerationUtils.findNodeRange(field.getPosition(), this.syntaxTree);
                if (operationKind == OperationKind.QUERY) {
                    ResourceFunction resourceFunction = new ResourceFunction(field.getName(), false, returns, position, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), params, links);
                    this.resourceFunctions.add(resourceFunction);
                } else if (operationKind == OperationKind.MUTATION) {
                    RemoteFunction remoteFunction = new RemoteFunction(field.getName(), returns, position, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), params, links);
                    this.remoteFunctions.add(remoteFunction);
                } else if (operationKind == OperationKind.SUBSCRIPTION) {
                    ResourceFunction resourceFunction = new ResourceFunction(field.getName(), true, returns, position, field.getDescription(), field.isDeprecated(), field.getDeprecationReason(), params, links);
                    this.resourceFunctions.add(resourceFunction);
                }
            });
        }
    }

    static enum OperationKind {
        QUERY,
        MUTATION,
        SUBSCRIPTION;

    }
}

