/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphqlmodelgenerator.core.utils;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.graphqlmodelgenerator.core.model.Interaction;
import io.ballerina.graphqlmodelgenerator.core.utils.CommonUtil;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.LinePosition;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Range;

public class ModelGenerationUtils {
    private static final String NON_NULL_FORMAT = "%s!";
    private static final String LIST_FORMAT = "[%s]";
    private static final String ARGS_TYPE_FORMAT = "%s = %s";
    private static final String UNICODE_REGEX = "\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}";
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}");
    private static final String SINGLE_QUOTE_CHARACTER = "'";

    public static String getFormattedFieldType(Type type) {
        if (type.getOfType() == null) {
            return type.getName();
        }
        if (type.getKind().equals((Object)TypeKind.NON_NULL)) {
            return ModelGenerationUtils.getFormattedString(NON_NULL_FORMAT, ModelGenerationUtils.getFormattedFieldType(type.getOfType()));
        }
        if (type.getKind().equals((Object)TypeKind.LIST)) {
            return ModelGenerationUtils.getFormattedString(LIST_FORMAT, ModelGenerationUtils.getFormattedFieldType(type.getOfType()));
        }
        return type.getName();
    }

    public static String getFormattedString(String format, String ... args) {
        return String.format(format, args);
    }

    public static String getFieldType(Type type) {
        if (type.getOfType() == null) {
            if (type.getKind().equals((Object)TypeKind.SCALAR)) {
                return null;
            }
            return type.getName();
        }
        if (type.getKind().equals((Object)TypeKind.NON_NULL)) {
            return ModelGenerationUtils.getFieldType(type.getOfType());
        }
        if (type.getKind().equals((Object)TypeKind.LIST)) {
            return ModelGenerationUtils.getFieldType(type.getOfType());
        }
        return type.getName();
    }

    public static String getPathOfFieldType(Type type) {
        if (type.getOfType() == null) {
            if (type.getKind().equals((Object)TypeKind.SCALAR)) {
                return null;
            }
            return type.getPosition() != null ? type.getPosition().getFilePath() : null;
        }
        if (type.getKind().equals((Object)TypeKind.NON_NULL)) {
            return ModelGenerationUtils.getPathOfFieldType(type.getOfType());
        }
        if (type.getKind().equals((Object)TypeKind.LIST)) {
            return ModelGenerationUtils.getPathOfFieldType(type.getOfType());
        }
        return null;
    }

    public static Type getType(Type type) {
        if (type.getOfType() == null) {
            return type;
        }
        if (type.getKind().equals((Object)TypeKind.NON_NULL)) {
            return ModelGenerationUtils.getType(type.getOfType());
        }
        if (type.getKind().equals((Object)TypeKind.LIST)) {
            return ModelGenerationUtils.getType(type.getOfType());
        }
        return type;
    }

    public static String getServiceBasePath(ServiceDeclarationNode serviceDefinition) {
        StringBuilder currentServiceName = new StringBuilder();
        NodeList serviceNameNodes = serviceDefinition.absoluteResourcePath();
        for (Node serviceBasedPathNode : serviceNameNodes) {
            currentServiceName.append(ModelGenerationUtils.removeEscapeCharacter(serviceBasedPathNode.toString()));
        }
        return currentServiceName.toString().trim();
    }

    public static List<Interaction> getInteractionList(Field field) {
        ArrayList<Interaction> links = new ArrayList<Interaction>();
        String link = ModelGenerationUtils.getFieldType(field.getType());
        if (link != null && !link.isBlank()) {
            links.add(new Interaction(link, ModelGenerationUtils.getPathOfFieldType(field.getType())));
        }
        return links;
    }

    public static List<Interaction> getInteractionList(InputValue inputValue) {
        ArrayList<Interaction> links = new ArrayList<Interaction>();
        String link = ModelGenerationUtils.getFieldType(inputValue.getType());
        if (link != null) {
            links.add(new Interaction(link, ModelGenerationUtils.getPathOfFieldType(inputValue.getType())));
        }
        return links;
    }

    public static String createArgType(InputValue arg) {
        if (arg.getDefaultValue() == null) {
            return ModelGenerationUtils.getFormattedFieldType(arg.getType());
        }
        return ModelGenerationUtils.getFormattedString(ARGS_TYPE_FORMAT, ModelGenerationUtils.getFormattedFieldType(arg.getType()), arg.getDefaultValue());
    }

    public static Position findNodeRange(Position position, SyntaxTree syntaxTree) {
        if (position == null) {
            return null;
        }
        LineRange lineRange = CommonUtil.toLineRange(position);
        Range range = CommonUtil.toRange(lineRange);
        NonTerminalNode methodNode = CommonUtil.findSTNode(range, syntaxTree);
        return new Position(position.getFilePath(), new LinePosition(methodNode.lineRange().startLine().line(), methodNode.lineRange().startLine().offset()), new LinePosition(methodNode.lineRange().endLine().line(), methodNode.lineRange().endLine().offset()));
    }

    private static String removeEscapeCharacter(String identifier) {
        if (identifier == null) {
            return null;
        }
        Matcher matcher = UNICODE_PATTERN.matcher(identifier);
        StringBuffer buffer = new StringBuffer(identifier.length());
        while (matcher.find()) {
            String leadingSlashes = matcher.group(1);
            if (ModelGenerationUtils.isEscapedNumericEscape(leadingSlashes)) continue;
            int codePoint = Integer.parseInt(matcher.group(2), 16);
            char[] chars = Character.toChars(codePoint);
            String ch = String.valueOf(chars);
            if (ch.equals("\\")) {
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + "\\u005C"));
                continue;
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + ch));
        }
        matcher.appendTail(buffer);
        String value = String.valueOf(buffer);
        if (value.startsWith(SINGLE_QUOTE_CHARACTER)) {
            return value.substring(1);
        }
        return value;
    }

    private static boolean isEscapedNumericEscape(String leadingSlashes) {
        return !ModelGenerationUtils.isEven(leadingSlashes.length());
    }

    private static boolean isEven(int n) {
        return (n & 1) == 0;
    }
}

