/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.runtime.engine.ArgumentHandler;
import io.ballerina.stdlib.graphql.runtime.engine.EngineUtils;
import io.ballerina.stdlib.graphql.runtime.engine.SchemaRecordGenerator;
import io.ballerina.stdlib.graphql.runtime.exception.ConstraintValidationException;
import io.ballerina.stdlib.graphql.runtime.utils.ModuleUtils;
import io.ballerina.stdlib.graphql.runtime.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;

public class Engine {
    public static final String RESOURCE_MAP = "graphql.resourceMap";

    private Engine() {
    }

    public static Object createSchema(BString schemaString) {
        try {
            Schema schema = Engine.getDecodedSchema(schemaString);
            SchemaRecordGenerator schemaRecordGenerator = new SchemaRecordGenerator(schema);
            return schemaRecordGenerator.getSchemaRecord();
        }
        catch (BError e) {
            return Utils.createError("Error occurred while creating the schema", "Error", e);
        }
        catch (NullPointerException e) {
            return Utils.createError("Failed to generate schema", "Error");
        }
    }

    public static Schema getDecodedSchema(BString schemaBString) {
        if (schemaBString == null) {
            throw Utils.createError("Schema generation failed due to null schema string", "Error");
        }
        if (schemaBString.getValue().isBlank() || schemaBString.getValue().isEmpty()) {
            throw Utils.createError("Schema generation failed due to empty schema string", "Error");
        }
        String schemaString = schemaBString.getValue();
        byte[] decodedString = Base64.getDecoder().decode(schemaString.getBytes(StandardCharsets.UTF_8));
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(decodedString);
            ObjectInputStream inputStream = new ObjectInputStream(byteStream);
            return (Schema)inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            BError cause = ErrorCreator.createError((BString)StringUtils.fromString((String)e.getMessage()));
            throw Utils.createError("Schema generation failed due to exception", "Error", cause);
        }
    }

    public static Object executeSubscriptionResource(Environment environment, BObject context, BObject service, BObject fieldObject, BObject responseGenerator, boolean validation) {
        BString fieldName = fieldObject.getObjectValue(Utils.INTERNAL_NODE).getStringValue(EngineUtils.NAME_FIELD);
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)service);
        for (ResourceMethodType resourceMethod : serviceType.getResourceMethods()) {
            if (!"subscribe".equals(resourceMethod.getAccessor()) || !fieldName.getValue().equals(io.ballerina.stdlib.graphql.commons.utils.TypeUtils.removeEscapeCharacter((String)resourceMethod.getResourcePath()[0]))) continue;
            ArgumentHandler argumentHandler = new ArgumentHandler((MethodType)resourceMethod, context, fieldObject, responseGenerator, validation);
            return Engine.getResultObject(environment, service, resourceMethod.getName(), argumentHandler);
        }
        return null;
    }

    private static Object getResultObject(Environment environment, BObject service, String methodName, ArgumentHandler argumentHandler) {
        try {
            argumentHandler.validateInputConstraint(environment);
        }
        catch (ConstraintValidationException e) {
            return null;
        }
        return environment.yieldAndRun(() -> {
            Object[] args = argumentHandler.getArguments();
            try {
                return Engine.callResourceMethod(environment.getRuntime(), service, methodName, args);
            }
            catch (BError bError) {
                Utils.handleFailureAndExit(bError);
                return null;
            }
        });
    }

    private static Object callResourceMethod(Runtime runtime, BObject service, String methodName, Object[] args) {
        return runtime.callMethod(service, methodName, null, args);
    }

    public static Object executeQueryResource(Environment environment, BObject context, BObject service, ResourceMethodType resourceMethod, BObject fieldObject, BObject responseGenerator, boolean validation) {
        if (resourceMethod == null) {
            return null;
        }
        ArgumentHandler argumentHandler = new ArgumentHandler((MethodType)resourceMethod, context, fieldObject, responseGenerator, validation);
        return Engine.getResultObject(environment, service, resourceMethod.getName(), argumentHandler);
    }

    public static Object executeMutationMethod(Environment environment, BObject context, BObject service, BObject fieldObject, BObject responseGenerator, boolean validation) {
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)service);
        String fieldName = fieldObject.getObjectValue(Utils.INTERNAL_NODE).getStringValue(EngineUtils.NAME_FIELD).getValue();
        for (RemoteMethodType remoteMethod : serviceType.getRemoteMethods()) {
            if (!remoteMethod.getName().equals(fieldName)) continue;
            ArgumentHandler argumentHandler = new ArgumentHandler((MethodType)remoteMethod, context, fieldObject, responseGenerator, validation);
            return Engine.getResultObject(environment, service, remoteMethod.getName(), argumentHandler);
        }
        return null;
    }

    public static Object executeInterceptor(Environment environment, BObject interceptor, BObject field, BObject context) {
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)interceptor);
        RemoteMethodType remoteMethod = Engine.getRemoteMethod(serviceType, "execute");
        if (remoteMethod == null) {
            return null;
        }
        return environment.yieldAndRun(() -> {
            Object[] arguments = Engine.getInterceptorArguments(context, field);
            try {
                return Engine.callResourceMethod(environment.getRuntime(), interceptor, remoteMethod.getName(), arguments);
            }
            catch (BError bError) {
                Utils.handleFailureAndExit(bError);
                return null;
            }
        });
    }

    public static Object getResourceMethod(BObject service, BArray path) {
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)service);
        List<String> pathList = Engine.getPathList(path);
        return Engine.getResourceMethod(serviceType, pathList, "get");
    }

    private static ResourceMethodType getResourceMethod(ServiceType serviceType, List<String> path, String accessor) {
        for (ResourceMethodType resourceMethod : serviceType.getResourceMethods()) {
            if (!accessor.equals(resourceMethod.getAccessor()) || !EngineUtils.isPathsMatching(resourceMethod, path)) continue;
            return resourceMethod;
        }
        return null;
    }

    private static List<String> getPathList(BArray pathArray) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < pathArray.size(); ++i) {
            BString pathSegment = (BString)pathArray.get((long)i);
            result.add(pathSegment.getValue());
        }
        return result;
    }

    public static Object getMethod(BObject service, BString methodName) {
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)service);
        return Engine.getMethod(serviceType, methodName.getValue());
    }

    private static MethodType getMethod(ServiceType serviceType, String methodName) {
        for (MethodType serviceMethod : serviceType.getMethods()) {
            if (!methodName.equals(serviceMethod.getName())) continue;
            return serviceMethod;
        }
        return null;
    }

    private static RemoteMethodType getRemoteMethod(ServiceType serviceType, String methodName) {
        for (RemoteMethodType remoteMethod : serviceType.getRemoteMethods()) {
            if (!remoteMethod.getName().equals(methodName)) continue;
            return remoteMethod;
        }
        return null;
    }

    private static Object[] getInterceptorArguments(BObject context, BObject field) {
        Object[] args = new Object[]{context, field};
        return args;
    }

    public static BString getInterceptorName(BObject interceptor) {
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)interceptor);
        return StringUtils.fromString((String)serviceType.getName());
    }

    public static Object getResourceAnnotation(BObject service, BString operationType, BArray path, BString methodName) {
        ServiceType serviceType = (ServiceType)TypeUtils.getType((Object)service);
        Object methodType = "query".equals(operationType.getValue()) ? Engine.getResourceMethod(serviceType, Engine.getPathList(path), "get") : ("subscription".equals(operationType.getValue()) ? Engine.getResourceMethod(serviceType, Engine.getPathList(path), "subscribe") : Engine.getRemoteMethod(serviceType, String.valueOf(methodName)));
        if (methodType != null) {
            BString identifier = StringUtils.fromString((String)(ModuleUtils.getModule().toString() + ":ResourceConfig"));
            return methodType.getAnnotation(identifier);
        }
        return null;
    }

    public static boolean hasPrefetchMethod(BObject serviceObject, BString prefetchMethodName) {
        ServiceType serviceType = (ServiceType)serviceObject.getOriginalType();
        return Arrays.stream(serviceType.getMethods()).anyMatch(methodType -> methodType.getName().equals(prefetchMethodName.getValue()));
    }

    public static void executePrefetchMethod(Environment environment, BObject context, BObject service, MethodType resourceMethod, BObject fieldObject) {
        environment.yieldAndRun(() -> {
            ArgumentHandler argumentHandler = new ArgumentHandler(resourceMethod, context, fieldObject, null, false);
            Object[] arguments = argumentHandler.getArguments();
            try {
                return Engine.callResourceMethod(environment.getRuntime(), service, resourceMethod.getName(), arguments);
            }
            catch (BError bError) {
                Utils.handleFailureAndExit(bError);
                return null;
            }
        });
    }

    public static boolean hasRecordReturnType(BObject serviceObject, BArray path) {
        ResourceMethodType resourceMethod = (ResourceMethodType)Engine.getResourceMethod(serviceObject, path);
        if (resourceMethod == null) {
            return false;
        }
        return Engine.isRecordReturnType(resourceMethod.getType().getReturnType());
    }

    static boolean isRecordReturnType(Type returnType) {
        if (returnType.getTag() == 33) {
            for (Type memberType : ((UnionType)returnType).getMemberTypes()) {
                if (!Engine.isRecordReturnType(memberType)) continue;
                return true;
            }
        } else {
            if (returnType.getTag() == 34) {
                Type effectiveType = TypeUtils.getReferredType((Type)ArgumentHandler.getEffectiveType((IntersectionType)returnType));
                return Engine.isRecordReturnType(effectiveType);
            }
            if (returnType.getTag() == 53) {
                return Engine.isRecordReturnType(TypeUtils.getReferredType((Type)returnType));
            }
        }
        return returnType.getTag() == 24;
    }

    public static HashMap<String, Object> getPropertiesToPropagate(Environment environment, BObject context) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ObserverContext observerContext = (ObserverContext)context.getNativeData("__observer_context__");
        if (observerContext == null) {
            observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)environment);
        }
        if (observerContext != null) {
            properties.put("__observer_context__", observerContext);
        }
        return properties;
    }
}

