/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.utils.SdlSchemaStringGenerator;
import io.ballerina.stdlib.graphql.runtime.engine.Engine;
import io.ballerina.stdlib.graphql.runtime.engine.meta.Resource;
import io.ballerina.stdlib.graphql.runtime.engine.meta.ServiceAnalyzer;
import io.ballerina.stdlib.graphql.runtime.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EngineUtils {
    public static final String SCHEMA_RECORD = "__Schema";
    public static final String FIELD_RECORD = "__Field";
    public static final String TYPE_RECORD = "__Type";
    public static final String INPUT_VALUE_RECORD = "__InputValue";
    public static final String ENUM_VALUE_RECORD = "__EnumValue";
    public static final String DIRECTIVE_RECORD = "__Directive";
    public static final String DIRECTIVE_LOCATION_ENUM = "__DirectiveLocation";
    public static final BString QUERY_TYPE_FIELD = StringUtils.fromString((String)"queryType");
    public static final BString MUTATION_TYPE_FIELD = StringUtils.fromString((String)"mutationType");
    public static final BString SUBSCRIPTION_TYPE_FIELD = StringUtils.fromString((String)"subscriptionType");
    public static final BString TYPES_FIELD = StringUtils.fromString((String)"types");
    public static final BString TYPE_FIELD = StringUtils.fromString((String)"type");
    public static final BString NAME_FIELD = StringUtils.fromString((String)"name");
    public static final BString DESCRIPTION_FIELD = StringUtils.fromString((String)"description");
    public static final BString DEPRECATION_REASON_FIELD = StringUtils.fromString((String)"deprecationReason");
    public static final BString IS_DEPRECATED_FIELD = StringUtils.fromString((String)"isDeprecated");
    public static final BString DIRECTIVES_FIELD = StringUtils.fromString((String)"directives");
    public static final BString KIND_FIELD = StringUtils.fromString((String)"kind");
    public static final BString FIELDS_FIELD = StringUtils.fromString((String)"fields");
    public static final BString ARGS_FIELD = StringUtils.fromString((String)"args");
    public static final BString DEFAULT_VALUE_FIELD = StringUtils.fromString((String)"defaultValue");
    public static final BString ENUM_VALUES_FIELD = StringUtils.fromString((String)"enumValues");
    public static final BString INPUT_FIELDS_FIELD = StringUtils.fromString((String)"inputFields");
    public static final BString OF_TYPE_FIELD = StringUtils.fromString((String)"ofType");
    public static final BString POSSIBLE_TYPES_FIELD = StringUtils.fromString((String)"possibleTypes");
    public static final BString INTERFACES_FIELD = StringUtils.fromString((String)"interfaces");
    public static final BString VARIABLE_VALUE_FIELD = StringUtils.fromString((String)"variableValue");
    public static final BString VARIABLE_DEFINITION = StringUtils.fromString((String)"variableDefinition");
    public static final String QUERY = "Query";
    public static final String MUTATION = "Mutation";
    public static final String SUBSCRIPTION = "Subscription";
    public static final String GET_ACCESSOR = "get";
    public static final String SUBSCRIBE_ACCESSOR = "subscribe";
    public static final String INTERCEPTOR_EXECUTE = "execute";
    public static final BString LOCATIONS_FIELD = StringUtils.fromString((String)"locations");
    static final BString ARGUMENTS_FIELD = StringUtils.fromString((String)"arguments");
    static final BString VALUE_FIELD = StringUtils.fromString((String)"value");
    static final BString VARIABLE_NAME_FIELD = StringUtils.fromString((String)"variableName");
    public static final String GRAPHQL_SERVICE_OBJECT = "graphql.service.object";
    public static final String FIELD_OBJECT = "field.object";
    public static final String FILE_INFO_FIELD = "graphql.context.fileInfo";
    public static final BString HAS_FILE_INFO_FIELD = StringUtils.fromString((String)"hasFileInfo");
    public static final BString RESULT_FIELD = StringUtils.fromString((String)"result");
    public static final String RESOURCE_CONFIG = "ResourceConfig";
    public static final String COLON = ":";
    public static final String OPERATION_QUERY = "query";
    public static final String OPERATION_SUBSCRIPTION = "subscription";

    private EngineUtils() {
    }

    public static void analyzeServices(BArray services) {
        for (int i = 0; i < services.size(); ++i) {
            BObject service = (BObject)services.get((long)i);
            ServiceAnalyzer serviceAnalyzer = new ServiceAnalyzer((ServiceType)TypeUtils.getType((Object)service));
            serviceAnalyzer.analyze();
            service.addNativeData("graphql.resourceMap", serviceAnalyzer.getResourceMap());
        }
    }

    static boolean isPathsMatching(ResourceMethodType resourceMethod, List<String> paths) {
        String[] resourcePath = resourceMethod.getResourcePath();
        if (resourcePath.length != paths.size()) {
            return false;
        }
        for (int i = 0; i < resourcePath.length; ++i) {
            if (io.ballerina.stdlib.graphql.commons.utils.TypeUtils.removeEscapeCharacter((String)resourcePath[i]).equals(paths.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnum(UnionType unionType) {
        return SymbolFlags.isFlagOn((long)unionType.getFlags(), (long)0x200000000L);
    }

    public static List<Type> getMemberTypes(UnionType unionType) {
        ArrayList<Type> members = new ArrayList<Type>();
        if (EngineUtils.isEnum(unionType)) {
            members.add((Type)unionType);
        } else {
            List originalMembers = unionType.getOriginalMemberTypes();
            for (Type type : originalMembers) {
                if (EngineUtils.isIgnoreType(type)) continue;
                if (type.getTag() == 33) {
                    members.addAll(EngineUtils.getMemberTypes((UnionType)type));
                    continue;
                }
                members.add(type);
            }
        }
        return members;
    }

    public static BArray getArrayTypeFromBMap(BMap<BString, Object> recordValue) {
        ArrayType arrayType = TypeCreator.createArrayType((Type)recordValue.getType());
        return ValueCreator.createArrayValue((ArrayType)arrayType);
    }

    public static boolean isIgnoreType(Type type) {
        return type.getTag() == 42 || type.getTag() == 14;
    }

    public static void addService(BObject engine, BObject service) {
        engine.addNativeData(GRAPHQL_SERVICE_OBJECT, (Object)service);
    }

    public static BObject getService(BObject engine) {
        return (BObject)engine.getNativeData(GRAPHQL_SERVICE_OBJECT);
    }

    public static void setFileInfo(BObject context, BMap<BString, Object> fileInfo) {
        context.addNativeData(FILE_INFO_FIELD, fileInfo);
        context.set(HAS_FILE_INFO_FIELD, (Object)true);
    }

    public static BMap<BString, Object> getFileInfo(BObject context) {
        return (BMap)context.getNativeData(FILE_INFO_FIELD);
    }

    public static boolean isMap(BMap<BString, Object> value) {
        Type type = TypeUtils.getReferredType((Type)value.getType());
        type = type.getTag() == 34 ? ((IntersectionType)type).getEffectiveType() : type;
        return type.getTag() == 27;
    }

    public static BString getTypeNameFromValue(BValue bValue) {
        if (bValue.getType().getTag() == 34) {
            return StringUtils.fromString((String)EngineUtils.getTypeNameFromIntersection((IntersectionType)bValue.getType()));
        }
        if (bValue.getType().getTag() == 24) {
            return StringUtils.fromString((String)EngineUtils.getTypeNameFromRecordValue((RecordType)bValue.getType()));
        }
        if (bValue.getType().getTag() == 31) {
            return StringUtils.fromString((String)bValue.getType().getName());
        }
        if (bValue.getType().getTag() == 53) {
            return StringUtils.fromString((String)bValue.getType().getName());
        }
        return StringUtils.fromString((String)"");
    }

    public static boolean isRecordWithNoOptionalFields(Object value) {
        BMap recordValue;
        Type type;
        if (value instanceof BMap && (type = TypeUtils.getImpliedType((Type)(recordValue = (BMap)value).getType())).getTag() == 24) {
            RecordType recordType = (RecordType)type;
            for (Field field : recordType.getFields().values()) {
                if (!SymbolFlags.isFlagOn((long)field.getFlags(), (long)4096L)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String getTypeNameFromRecordValue(RecordType recordType) {
        if (recordType.getName().contains("&") && recordType.getIntersectionType().isPresent()) {
            for (Type constituentType : ((IntersectionType)recordType.getIntersectionType().get()).getConstituentTypes()) {
                if (constituentType.getTag() == 51) continue;
                return constituentType.getName();
            }
        }
        return recordType.getName();
    }

    static String getTypeNameFromIntersection(IntersectionType intersectionType) {
        for (Type constituentType : intersectionType.getConstituentTypes()) {
            if (constituentType.getTag() == 51) continue;
            return constituentType.getName();
        }
        return intersectionType.getEffectiveType().getName();
    }

    public static void setField(BObject context, BObject field) {
        context.addNativeData(FIELD_OBJECT, (Object)field);
    }

    public static BObject getField(BObject context) {
        return (BObject)context.getNativeData(FIELD_OBJECT);
    }

    public static Object getSdlString(BString schemaString) {
        Schema schema = Engine.getDecodedSchema(schemaString);
        String sdl = SdlSchemaStringGenerator.generate((Schema)schema, (boolean)true);
        return StringUtils.fromString((String)sdl);
    }

    public static void setResult(BObject executorVisitor, Object result) {
        executorVisitor.set(RESULT_FIELD, result);
    }

    public static Object getResult(BObject executorVisitor) {
        return executorVisitor.get(RESULT_FIELD);
    }

    public static Object getFieldComplexity(BObject engine, BString coordinate) {
        String coordinateKey;
        BObject serviceObject = (BObject)engine.getNativeData(GRAPHQL_SERVICE_OBJECT);
        Map resourceMap = (Map)serviceObject.getNativeData("graphql.resourceMap");
        if (resourceMap.containsKey(coordinateKey = coordinate.getValue())) {
            Resource resource = (Resource)resourceMap.get(coordinateKey);
            return resource.complexity();
        }
        return Utils.createError("Complexity not found for the resource: " + coordinateKey, "Error");
    }
}

