/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine.meta;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.graphql.runtime.engine.meta.Resource;
import io.ballerina.stdlib.graphql.runtime.utils.ModuleUtils;
import io.ballerina.stdlib.graphql.runtime.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServiceAnalyzer {
    private static final BString packageName = StringUtils.fromString((String)ModuleUtils.getModule().toString());
    private static final BString serviceConfigName = StringUtils.fromString((String)"ServiceConfig");
    private static final BString resourceConfigName = StringUtils.fromString((String)"ResourceConfig");
    private static final BString queryComplexityConfigKey = StringUtils.fromString((String)"queryComplexityConfig");
    private static final BString defaultComplexityKey = StringUtils.fromString((String)"defaultFieldComplexity");
    private static final BString complexityKey = StringUtils.fromString((String)"complexity");
    private final Map<String, Resource> resourceMap;
    private final ServiceType serviceType;
    private final Long defaultQueryComplexity;
    private final Set<Type> visitedTypes = new HashSet<Type>();

    public ServiceAnalyzer(ServiceType serviceType) {
        this.resourceMap = new HashMap<String, Resource>();
        this.serviceType = serviceType;
        BMap<BString, Object> serviceConfig = ServiceAnalyzer.getServiceConfig(serviceType);
        this.defaultQueryComplexity = ServiceAnalyzer.getDefaultQueryComplexity(serviceConfig);
    }

    public void analyze() {
        for (ResourceMethodType resourceMethodType : this.serviceType.getResourceMethods()) {
            String typeName = ServiceAnalyzer.getRootTypeName(resourceMethodType);
            this.analyzeResourceMethod(resourceMethodType, typeName);
        }
        for (ResourceMethodType resourceMethodType : this.serviceType.getRemoteMethods()) {
            String coordinate = "Mutation." + resourceMethodType.getName();
            this.analyzeRemoteMethod((RemoteMethodType)resourceMethodType, coordinate);
        }
    }

    private void analyzeResourceMethod(ResourceMethodType resourceMethod, String typeName) {
        String coordinate = ServiceAnalyzer.getSchemaCoordinate(typeName, resourceMethod);
        if (this.resourceMap.containsKey(coordinate)) {
            return;
        }
        BMap<BString, Object> resourceConfig = ServiceAnalyzer.getResourceConfig((MethodType)resourceMethod);
        Long complexity = this.getComplexity(coordinate, resourceConfig);
        Resource resource = new Resource(complexity);
        this.resourceMap.put(coordinate, resource);
        this.analyzeType(resourceMethod.getType().getReturnType());
    }

    private void analyzeRemoteMethod(RemoteMethodType remoteMethod, String coordinate) {
        BMap<BString, Object> resourceConfig = ServiceAnalyzer.getResourceConfig((MethodType)remoteMethod);
        Long complexity = this.getComplexity(coordinate, resourceConfig);
        Resource resource = new Resource(complexity);
        this.resourceMap.put(coordinate, resource);
        this.analyzeType(remoteMethod.getType().getReturnType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void analyzeType(Type type) {
        Type impliedType = TypeUtils.getImpliedType((Type)type);
        if (!this.visitedTypes.add(impliedType)) {
            return;
        }
        try {
            switch (impliedType.getTag()) {
                case 31: {
                    this.analyzeServiceType((ServiceType)impliedType);
                    return;
                }
                case 33: {
                    this.analyzeUnionType((UnionType)impliedType);
                    return;
                }
                case 32: {
                    this.analyzeType(((ArrayType)impliedType).getElementType());
                    return;
                }
                case 17: {
                    this.analyzeType(((TableType)impliedType).getConstrainedType());
                    return;
                }
                case 24: {
                    this.analyzeRecordType((RecordType)impliedType);
                    return;
                }
                case 27: {
                    this.analyzeType(((MapType)impliedType).getConstrainedType());
                    return;
                }
                case 26: {
                    this.analyzeType(((StreamType)impliedType).getConstrainedType());
                    return;
                }
            }
            return;
        }
        finally {
            this.visitedTypes.remove(impliedType);
        }
    }

    private void analyzeServiceType(ServiceType serviceType) {
        for (ResourceMethodType resourceMethod : serviceType.getResourceMethods()) {
            String typeName = serviceType.getName();
            this.analyzeResourceMethod(resourceMethod, typeName);
        }
    }

    private void analyzeUnionType(UnionType unionType) {
        for (Type memberType : unionType.getMemberTypes()) {
            if (memberType.getTag() == 14 && memberType.getTag() == 42) continue;
            this.analyzeType(memberType);
        }
    }

    private void analyzeRecordType(RecordType recordType) {
        String typeName = recordType.getName();
        for (Field field : recordType.getFields().values()) {
            String coordinate = typeName + "." + field.getFieldName();
            Resource resource = new Resource(this.defaultQueryComplexity);
            this.resourceMap.put(coordinate, resource);
            this.analyzeType(field.getFieldType());
        }
    }

    public Map<String, Resource> getResourceMap() {
        return this.resourceMap;
    }

    private Long getComplexity(String coordinate, BMap<BString, Object> resourceConfig) {
        if (resourceConfig == null) {
            return this.defaultQueryComplexity;
        }
        if (resourceConfig.containsKey((Object)complexityKey)) {
            Long complexity = (Long)resourceConfig.get((Object)complexityKey);
            if (complexity < 0L) {
                String message = "Complexity of the field \"" + coordinate + "\" cannot be negative";
                throw Utils.createError(message, "Error");
            }
            return (Long)resourceConfig.get((Object)complexityKey);
        }
        return this.defaultQueryComplexity;
    }

    private static String getRootTypeName(ResourceMethodType resourceMethod) {
        if (resourceMethod.getAccessor().equals("subscribe")) {
            return "Subscription";
        }
        return "Query";
    }

    private static String getSchemaCoordinate(String typeName, ResourceMethodType resourceMethodType) {
        String[] resourcePath = resourceMethodType.getResourcePath();
        if (resourcePath.length == 1) {
            return typeName + "." + resourcePath[0];
        }
        int length = resourcePath.length;
        return resourcePath[length - 2] + "." + resourcePath[length - 1];
    }

    private static Long getDefaultQueryComplexity(BMap<BString, Object> serviceConfig) {
        if (serviceConfig == null) {
            return 0L;
        }
        Object queryComplexityConfig = serviceConfig.get((Object)queryComplexityConfigKey);
        if (queryComplexityConfig == null) {
            return 0L;
        }
        BMap queryComplexityConfigMap = (BMap)queryComplexityConfig;
        return (Long)queryComplexityConfigMap.get((Object)defaultComplexityKey);
    }

    private static BMap<BString, Object> getServiceConfig(ServiceType serviceType) {
        Object annotation = serviceType.getAnnotation(packageName, serviceConfigName);
        if (annotation == null) {
            return null;
        }
        return (BMap)annotation;
    }

    private static BMap<BString, Object> getResourceConfig(MethodType method) {
        Object resourceConfig = method.getAnnotation(packageName, resourceConfigName);
        if (resourceConfig == null) {
            return null;
        }
        return (BMap)resourceConfig;
    }
}

