/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.document.DocCommentsGeneratorUtil;
import io.ballerina.openapi.core.generators.type.GeneratorConstants;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AuthConfigGeneratorImp {
    private final Map<String, ApiKeyNamePair> headerApiKeyNameMap = new HashMap<String, ApiKeyNamePair>();
    private final Map<String, ApiKeyNamePair> queryApiKeyNameMap = new HashMap<String, ApiKeyNamePair>();
    private final List<Node> apiKeysConfigRecordFields = new ArrayList<Node>();
    private boolean apiKey;
    private boolean httpOROAuth;
    private String clientCredGrantTokenUrl;
    private String passwordGrantTokenUrl;
    private String refreshTokenUrl;
    private String httpVersion = GeneratorConstants.HTTP_VERSION_MAP.get("2.0");
    private final Set<String> authTypes = new LinkedHashSet<String>();
    private List<TypeDefinitionNode> authRelatedTypeDefinitionNodes = new ArrayList<TypeDefinitionNode>();
    private List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();

    public AuthConfigGeneratorImp(boolean isAPIKey, boolean isHttpOROAuth) {
        this.apiKey = isAPIKey;
        this.httpOROAuth = isHttpOROAuth;
    }

    public boolean isApiKey() {
        return this.apiKey;
    }

    public boolean isHttpOROAuth() {
        return this.httpOROAuth;
    }

    public Map<String, ApiKeyNamePair> getQueryApiKeyNameMap() {
        return this.queryApiKeyNameMap;
    }

    public Map<String, ApiKeyNamePair> getHeaderApiKeyNameMap() {
        return this.headerApiKeyNameMap;
    }

    public Set<String> getAuthType() {
        return this.authTypes;
    }

    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public List<TypeDefinitionNode> getAuthRelatedTypeDefinitionNodes() {
        return this.authRelatedTypeDefinitionNodes;
    }

    public void addAuthRelatedRecords(OpenAPI openAPI) throws ClientException {
        ArrayList<TypeDefinitionNode> nodes = new ArrayList<TypeDefinitionNode>();
        if (openAPI.getComponents() != null) {
            String httpVersion;
            LinkedHashMap extFields;
            if (openAPI.getComponents().getSecuritySchemes() != null) {
                Map securitySchemeMap = openAPI.getComponents().getSecuritySchemes();
                this.setAuthTypes(securitySchemeMap, openAPI);
            }
            if (openAPI.getExtensions() != null && openAPI.getExtensions().containsKey("x-ballerina-http-configurations") && (extFields = (LinkedHashMap)openAPI.getExtensions().get("x-ballerina-http-configurations")).containsKey("httpVersion") && (httpVersion = (String)extFields.get("httpVersion")) != null && GeneratorConstants.HTTP_VERSION_MAP.containsKey(httpVersion)) {
                this.httpVersion = GeneratorConstants.HTTP_VERSION_MAP.get(httpVersion);
            }
            TypeDefinitionNode connectionConfigRecord = this.generateConnectionConfigRecord();
            nodes.addAll(Arrays.asList(connectionConfigRecord));
            if (this.isApiKey()) {
                nodes.add(this.generateApiKeysConfig());
            }
            if (this.clientCredGrantTokenUrl != null) {
                nodes.add(this.getOAuth2ClientCredsGrantConfigRecord());
            }
            if (this.passwordGrantTokenUrl != null) {
                nodes.add(this.getOAuth2PasswordGrantConfigRecord());
            }
            if (this.refreshTokenUrl != null) {
                nodes.add(this.getOAuth2RefreshTokenGrantConfigRecord());
            }
        }
        this.authRelatedTypeDefinitionNodes = nodes;
    }

    public TypeDefinitionNode generateConnectionConfigRecord() {
        AnnotationNode annotationNode = this.getDisplayAnnotationForRecord("Connection Config");
        MetadataNode configRecordMetadataNode = this.getMetadataNode("Provides a set of configurations for controlling the behaviours when communicating with a remote HTTP endpoint.", Collections.singletonList(annotationNode));
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)"ConnectionConfig");
        NodeList recordFieldList = NodeFactory.createNodeList(this.getClientConfigRecordFields());
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        TypeDefinitionNode node = NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        return node;
    }

    public TypeDefinitionNode generateApiKeysConfig() {
        MetadataNode configRecordMetadataNode = this.getMetadataNode("Provides API key configurations needed when communicating with a remote HTTP endpoint.");
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig");
        NodeList recordFieldList = NodeFactory.createNodeList(this.apiKeysConfigRecordFields);
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDefinitionNode getOAuth2ClientCredsGrantConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GeneratorConstants.AuthConfigTypes.CUSTOM_CLIENT_CREDENTIAL.getValue());
        NodeList recordFieldList = NodeFactory.createNodeList(this.getClientCredsGrantConfigFields());
        MetadataNode configRecordMetadataNode = this.getMetadataNode("OAuth2 Client Credentials Grant Configs");
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private List<Node> getClientCredsGrantConfigFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        recordFieldNodes.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)"http:OAuth2ClientCredentialsGrantConfig;"), null));
        MetadataNode metadataNode = this.getMetadataNode("Token URL");
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken fieldNameTokenUrl = AbstractNodeFactory.createIdentifierToken((String)"tokenUrl");
        RequiredExpressionNode defaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.clientCredGrantTokenUrl + "\"")));
        RecordFieldWithDefaultValueNode fieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)stringType, (Token)fieldNameTokenUrl, (Token)equalToken, (ExpressionNode)defaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)fieldNode);
        return recordFieldNodes;
    }

    private TypeDefinitionNode getOAuth2PasswordGrantConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GeneratorConstants.AuthConfigTypes.CUSTOM_PASSWORD.getValue());
        NodeList recordFieldList = NodeFactory.createNodeList(this.getPasswordGrantConfigFields());
        MetadataNode configRecordMetadataNode = this.getMetadataNode("OAuth2 Password Grant Configs");
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private List<Node> getPasswordGrantConfigFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        recordFieldNodes.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)"http:OAuth2PasswordGrantConfig;"), null));
        MetadataNode metadataNode = this.getMetadataNode("Token URL");
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken fieldNameTokenUrl = AbstractNodeFactory.createIdentifierToken((String)"tokenUrl");
        RequiredExpressionNode defaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.passwordGrantTokenUrl + "\"")));
        RecordFieldWithDefaultValueNode fieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)stringType, (Token)fieldNameTokenUrl, (Token)equalToken, (ExpressionNode)defaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)fieldNode);
        return recordFieldNodes;
    }

    private TypeDefinitionNode getOAuth2RefreshTokenGrantConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GeneratorConstants.AuthConfigTypes.CUSTOM_REFRESH_TOKEN.getValue());
        NodeList recordFieldList = NodeFactory.createNodeList(this.getRefreshTokenGrantConfigFields());
        MetadataNode configRecordMetadataNode = this.getMetadataNode("OAuth2 Refresh Token Grant Configs");
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private List<Node> getRefreshTokenGrantConfigFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        recordFieldNodes.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)"http:OAuth2RefreshTokenGrantConfig;"), null));
        MetadataNode metadataNode = this.getMetadataNode("Refresh URL");
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken fieldNameTokenUrl = AbstractNodeFactory.createIdentifierToken((String)"refreshUrl");
        RequiredExpressionNode defaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.refreshTokenUrl + "\"")));
        RecordFieldWithDefaultValueNode fieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)stringType, (Token)fieldNameTokenUrl, (Token)equalToken, (ExpressionNode)defaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)fieldNode);
        return recordFieldNodes;
    }

    public ObjectFieldNode getApiKeyMapClassVariable() {
        if (this.apiKey) {
            NodeList qualifierList = NodeFactory.createNodeList((Node[])new Token[]{NodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD)});
            TypeReferenceTypeDescNode readOnlyNode = NodeFactory.createTypeReferenceTypeDescNode((NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.READONLY_KEYWORD)));
            SimpleNameReferenceNode apiKeyMapNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
            if (this.httpOROAuth) {
                apiKeyMapNode = NodeFactory.createOptionalTypeDescriptorNode((Node)apiKeyMapNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
            }
            IntersectionTypeDescriptorNode intersectionTypeDescriptorNode = NodeFactory.createIntersectionTypeDescriptorNode((Node)readOnlyNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.BITWISE_AND_TOKEN), (Node)apiKeyMapNode);
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig");
            MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
            return NodeFactory.createObjectFieldNode((MetadataNode)metadataNode, null, (NodeList)qualifierList, (Node)intersectionTypeDescriptorNode, (Token)fieldName, null, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        }
        return null;
    }

    public List<ParameterNode> getConfigParamForClassInit() {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        ArrayList<ParameterNode> parameters = new ArrayList<ParameterNode>();
        IdentifierToken equalToken = AbstractNodeFactory.createIdentifierToken((String)"=");
        if (this.httpOROAuth) {
            BuiltinSimpleNameReferenceNode typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ConnectionConfig"));
            IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)"config");
            RequiredParameterNode authConfig = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)typeName, (Token)paramName);
            parameters.add((ParameterNode)authConfig);
        } else {
            if (this.apiKey) {
                BuiltinSimpleNameReferenceNode apiKeyConfigTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
                IdentifierToken apiKeyConfigParamName = AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig");
                RequiredParameterNode apiKeyConfigParamNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)apiKeyConfigTypeName, (Token)apiKeyConfigParamName);
                parameters.add((ParameterNode)apiKeyConfigParamNode);
            }
            BuiltinSimpleNameReferenceNode httpClientConfigTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ConnectionConfig"));
            IdentifierToken httpClientConfig = AbstractNodeFactory.createIdentifierToken((String)"config");
            BasicLiteralNode emptyexpression = NodeFactory.createBasicLiteralNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)" {}"));
            DefaultableParameterNode defaultConnectionConfig = NodeFactory.createDefaultableParameterNode((NodeList)annotationNodes, (Node)httpClientConfigTypeName, (Token)httpClientConfig, (Token)equalToken, (Node)emptyexpression);
            parameters.add((ParameterNode)defaultConnectionConfig);
        }
        return parameters;
    }

    public VariableDeclarationNode getHttpClientConfigVariableNode() {
        Token comma = NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        SimpleNameReferenceNode typeBindingPattern = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ClientConfiguration"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"httpClientConfig"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        ArrayList<Object> argumentsList = new ArrayList<Object>();
        if (this.isHttpOROAuth() && !this.isApiKey()) {
            SpecificFieldNode authField = AuthConfigGeneratorImp.createClientConfigFieldAssignmentNode("auth");
            argumentsList.add(authField);
            argumentsList.add(comma);
        }
        io.ballerina.openapi.core.generators.common.GeneratorConstants.CLIENT_CONFIG_FIELD_LIST.forEach(configField -> {
            SpecificFieldNode field = AuthConfigGeneratorImp.createClientConfigFieldAssignmentNode(configField);
            argumentsList.add(field);
            argumentsList.add(comma);
        });
        if (!argumentsList.isEmpty()) {
            argumentsList.removeLast();
        }
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argumentsList);
        MappingConstructorExpressionNode mappingConstructorExpressionNode = NodeFactory.createMappingConstructorExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)arguments, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)mappingConstructorExpressionNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private static SpecificFieldNode createClientConfigFieldAssignmentNode(String fieldName) {
        FieldAccessExpressionNode fieldValueExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"config")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)fieldName)));
        return NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)fieldName), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)fieldValueExpr);
    }

    public AssignmentStatementNode getClientInitializationNode() {
        FieldAccessExpressionNode selfClientExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientEp")));
        ArrayList<Object> argumentsList = new ArrayList<Object>();
        PositionalArgumentNode positionalArgumentNode01 = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"serviceUrl")));
        argumentsList.add(positionalArgumentNode01);
        IdentifierToken comma1 = AbstractNodeFactory.createIdentifierToken((String)",");
        PositionalArgumentNode positionalArgumentNode02 = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"httpClientConfig")));
        argumentsList.add(comma1);
        argumentsList.add(positionalArgumentNode02);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argumentsList);
        Token closeParenArg = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        ParenthesizedArgList parenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)closeParenArg);
        ImplicitNewExpressionNode expressionNode = NodeFactory.createImplicitNewExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)parenthesizedArgList);
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)expressionNode);
        return NodeFactory.createAssignmentStatementNode((Node)selfClientExp, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public AssignmentStatementNode getApiKeyAssignmentNode() {
        if (this.apiKey) {
            FieldAccessExpressionNode varRefApiKey = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig")));
            RequiredExpressionNode fieldAccessExpressionNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig"));
            MethodCallExpressionNode methodCallExpressionNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)fieldAccessExpressionNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"cloneReadOnly")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
            return NodeFactory.createAssignmentStatementNode((Node)varRefApiKey, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)methodCallExpressionNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        }
        return null;
    }

    private List<Node> getClientConfigRecordFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        Token questionMarkToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        if (this.isHttpOROAuth() && !this.isApiKey()) {
            authMetadataNode = this.getMetadataNode("Configurations related to client authentication");
            authFieldName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier("auth"));
            SimpleNameReferenceNode authFieldTypeNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.getAuthFieldTypeName()));
            authFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)authMetadataNode, null, (Node)authFieldTypeNode, (Token)authFieldName, null, (Token)semicolonToken);
            recordFieldNodes.add((Node)authFieldNode);
        } else if (this.isHttpOROAuth() && this.isApiKey()) {
            authMetadataNode = this.getMetadataNode("Provides Auth configurations needed when communicating with a remote HTTP endpoint.");
            authFieldName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier("auth"));
            UnionTypeDescriptorNode unionTypeDesctiptor = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.getAuthFieldTypeName())), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig")));
            authFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)authMetadataNode, null, (Node)unionTypeDesctiptor, (Token)authFieldName, null, (Token)semicolonToken);
            recordFieldNodes.add((Node)authFieldNode);
        }
        MetadataNode httpVersionMetadata = this.getMetadataNode("The HTTP version understood by the client");
        SimpleNameReferenceNode httpVersionFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:HttpVersion"));
        IdentifierToken httpVersionFieldName = AbstractNodeFactory.createIdentifierToken((String)"httpVersion");
        RequiredExpressionNode httpVersionExpression = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.httpVersion));
        RecordFieldWithDefaultValueNode httpVersionFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)httpVersionMetadata, null, (Node)httpVersionFieldType, (Token)httpVersionFieldName, (Token)equalToken, (ExpressionNode)httpVersionExpression, (Token)semicolonToken);
        recordFieldNodes.add((Node)httpVersionFieldNode);
        MetadataNode http1SettingsMetadata = this.getMetadataNode("Configurations related to HTTP/1.x protocol");
        IdentifierToken http1SettingsFieldName = AbstractNodeFactory.createIdentifierToken((String)"http1Settings");
        SimpleNameReferenceNode http1SettingsFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ClientHttp1Settings"));
        RecordFieldWithDefaultValueNode http1SettingsFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)http1SettingsMetadata, null, (Node)http1SettingsFieldType, (Token)http1SettingsFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"{}")), (Token)semicolonToken);
        recordFieldNodes.add((Node)http1SettingsFieldNode);
        MetadataNode http2SettingsMetadata = this.getMetadataNode("Configurations related to HTTP/2 protocol");
        SimpleNameReferenceNode http2SettingsFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ClientHttp2Settings"));
        IdentifierToken http2SettingsFieldName = AbstractNodeFactory.createIdentifierToken((String)"http2Settings");
        RecordFieldWithDefaultValueNode http2SettingsFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)http2SettingsMetadata, null, (Node)http2SettingsFieldType, (Token)http2SettingsFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"{}")), (Token)semicolonToken);
        recordFieldNodes.add((Node)http2SettingsFieldNode);
        MetadataNode timeoutMetadata = this.getMetadataNode("The maximum time to wait (in seconds) for a response before closing the connection");
        IdentifierToken timeoutFieldName = AbstractNodeFactory.createIdentifierToken((String)"timeout");
        SimpleNameReferenceNode timeoutFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DECIMAL_KEYWORD));
        RequiredExpressionNode decimalLiteralNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"30"));
        RecordFieldWithDefaultValueNode timeoutFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)timeoutMetadata, null, (Node)timeoutFieldType, (Token)timeoutFieldName, (Token)equalToken, (ExpressionNode)decimalLiteralNode, (Token)semicolonToken);
        recordFieldNodes.add((Node)timeoutFieldNode);
        MetadataNode forwardedMetadata = this.getMetadataNode("The choice of setting `forwarded`/`x-forwarded` header");
        IdentifierToken forwardedFieldName = AbstractNodeFactory.createIdentifierToken((String)"forwarded");
        SimpleNameReferenceNode forwardedFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        RequiredExpressionNode forwardedDefaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"\"disable\""));
        RecordFieldWithDefaultValueNode forwardedFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)forwardedMetadata, null, (Node)forwardedFieldType, (Token)forwardedFieldName, (Token)equalToken, (ExpressionNode)forwardedDefaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)forwardedFieldNode);
        MetadataNode followRedirectsMetadata = this.getMetadataNode("Configurations associated with Redirection");
        IdentifierToken followRedirectsFieldName = AbstractNodeFactory.createIdentifierToken((String)"followRedirects");
        SimpleNameReferenceNode followRedirectsFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:FollowRedirects"));
        RecordFieldNode followRedirectsFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)followRedirectsMetadata, null, (Node)followRedirectsFieldType, (Token)followRedirectsFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)followRedirectsFieldNode);
        MetadataNode poolConfigMetaData = this.getMetadataNode("Configurations associated with request pooling");
        IdentifierToken poolConfigFieldName = AbstractNodeFactory.createIdentifierToken((String)"poolConfig");
        SimpleNameReferenceNode poolConfigFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:PoolConfiguration"));
        RecordFieldNode poolConfigFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)poolConfigMetaData, null, (Node)poolConfigFieldType, (Token)poolConfigFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)poolConfigFieldNode);
        MetadataNode cachMetadata = this.getMetadataNode("HTTP caching related configurations");
        IdentifierToken cacheFieldName = AbstractNodeFactory.createIdentifierToken((String)"cache");
        SimpleNameReferenceNode cacheFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:CacheConfig"));
        RecordFieldWithDefaultValueNode cachFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)cachMetadata, null, (Node)cacheFieldType, (Token)cacheFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"{}")), (Token)semicolonToken);
        recordFieldNodes.add((Node)cachFieldNode);
        MetadataNode compressionMetadata = this.getMetadataNode("Specifies the way of handling compression (`accept-encoding`) header");
        IdentifierToken compressionFieldName = AbstractNodeFactory.createIdentifierToken((String)"compression");
        SimpleNameReferenceNode compressionFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Compression"));
        RequiredExpressionNode compressionDefaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:COMPRESSION_AUTO"));
        RecordFieldWithDefaultValueNode compressionFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)compressionMetadata, null, (Node)compressionFieldType, (Token)compressionFieldName, (Token)equalToken, (ExpressionNode)compressionDefaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)compressionFieldNode);
        MetadataNode circuitBreakerMetadata = this.getMetadataNode("Configurations associated with the behaviour of the Circuit Breaker");
        IdentifierToken circuitBreakerFieldName = AbstractNodeFactory.createIdentifierToken((String)"circuitBreaker");
        SimpleNameReferenceNode circuitBreakerFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:CircuitBreakerConfig"));
        RecordFieldNode circuitBreakerFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)circuitBreakerMetadata, null, (Node)circuitBreakerFieldType, (Token)circuitBreakerFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)circuitBreakerFieldNode);
        MetadataNode retryConfigMetadata = this.getMetadataNode("Configurations associated with retrying");
        IdentifierToken retryConfigFieldName = AbstractNodeFactory.createIdentifierToken((String)"retryConfig");
        SimpleNameReferenceNode retryConfigFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:RetryConfig"));
        RecordFieldNode retryConfigFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)retryConfigMetadata, null, (Node)retryConfigFieldType, (Token)retryConfigFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)retryConfigFieldNode);
        MetadataNode cookieConfigMetadata = this.getMetadataNode("Configurations associated with cookies");
        IdentifierToken cookieConfigFieldName = AbstractNodeFactory.createIdentifierToken((String)"cookieConfig");
        SimpleNameReferenceNode cookieConfigFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:CookieConfig"));
        RecordFieldNode cookieConfigFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)cookieConfigMetadata, null, (Node)cookieConfigFieldType, (Token)cookieConfigFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)cookieConfigFieldNode);
        MetadataNode responseLimitsMetadata = this.getMetadataNode("Configurations associated with inbound response size limits");
        IdentifierToken responseLimitsFieldName = AbstractNodeFactory.createIdentifierToken((String)"responseLimits");
        SimpleNameReferenceNode responseLimitsFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ResponseLimitConfigs"));
        RecordFieldWithDefaultValueNode responseLimitsFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)responseLimitsMetadata, null, (Node)responseLimitsFieldType, (Token)responseLimitsFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"{}")), (Token)semicolonToken);
        recordFieldNodes.add((Node)responseLimitsFieldNode);
        MetadataNode secureSocketMetadata = this.getMetadataNode("SSL/TLS-related options");
        IdentifierToken secureSocketFieldName = AbstractNodeFactory.createIdentifierToken((String)"secureSocket");
        SimpleNameReferenceNode secureSocketfieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ClientSecureSocket"));
        RecordFieldNode secureSocketFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)secureSocketMetadata, null, (Node)secureSocketfieldType, (Token)secureSocketFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)secureSocketFieldNode);
        MetadataNode proxyConfigMetadata = this.getMetadataNode("Proxy server related options");
        IdentifierToken proxyConfigFieldName = AbstractNodeFactory.createIdentifierToken((String)"proxy");
        SimpleNameReferenceNode proxyConfigFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ProxyConfig"));
        RecordFieldNode proxyConfigFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)proxyConfigMetadata, null, (Node)proxyConfigFieldType, (Token)proxyConfigFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)proxyConfigFieldNode);
        MetadataNode socketConfigFieldMetadata = this.getMetadataNode("Provides settings related to client socket configuration");
        IdentifierToken socketConfigFieldName = AbstractNodeFactory.createIdentifierToken((String)"socketConfig");
        SimpleNameReferenceNode socketConfigFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:ClientSocketConfig"));
        RecordFieldWithDefaultValueNode socketConfigFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)socketConfigFieldMetadata, null, (Node)socketConfigFieldType, (Token)socketConfigFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"{}")), (Token)semicolonToken);
        recordFieldNodes.add((Node)socketConfigFieldNode);
        MetadataNode validationMetadata = this.getMetadataNode("Enables the inbound payload validation functionality which provided by the constraint package. Enabled by default");
        IdentifierToken validationFieldName = AbstractNodeFactory.createIdentifierToken((String)"validation");
        SimpleNameReferenceNode validationFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"boolean"));
        RecordFieldWithDefaultValueNode validateFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)validationMetadata, null, (Node)validationFieldType, (Token)validationFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TRUE_KEYWORD)), (Token)semicolonToken);
        recordFieldNodes.add((Node)validateFieldNode);
        String apiComment = "Enables relaxed data binding on the client side. When enabled, `nil` values are treated as optional, \nand absent fields are handled as `nilable` types. Enabled by default.";
        MetadataNode laxDataBindingMetadata = this.getMetadataNode(apiComment);
        IdentifierToken laxDataBindingFieldName = AbstractNodeFactory.createIdentifierToken((String)"laxDataBinding");
        SimpleNameReferenceNode laxDataBindingFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"boolean"));
        RecordFieldWithDefaultValueNode laxDataBindingFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)laxDataBindingMetadata, null, (Node)laxDataBindingFieldType, (Token)laxDataBindingFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TRUE_KEYWORD)), (Token)semicolonToken);
        recordFieldNodes.add((Node)laxDataBindingFieldNode);
        return recordFieldNodes;
    }

    public IfElseStatementNode handleInitForMixOfApiKeyAndHTTPOrOAuth() {
        ArrayList<AssignmentStatementNode> apiKeyConfigAssignmentNodes = new ArrayList<AssignmentStatementNode>();
        FieldAccessExpressionNode apiKeyConfigRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig")));
        SimpleNameReferenceNode apiKeyConfigExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"(<ApiKeysConfig>config.auth).cloneReadOnly()"));
        AssignmentStatementNode apiKeyConfigAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)apiKeyConfigRef, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)apiKeyConfigExpr, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        apiKeyConfigAssignmentNodes.add(apiKeyConfigAssignmentStatementNode);
        NodeList statementList = NodeFactory.createNodeList(apiKeyConfigAssignmentNodes);
        BlockStatementNode ifBody = NodeFactory.createBlockStatementNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)statementList, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        ArrayList<AssignmentStatementNode> clientConfigAssignmentNodes = new ArrayList<AssignmentStatementNode>();
        FieldAccessExpressionNode clientConfigAuthRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"httpClientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"auth")));
        SimpleNameReferenceNode clientConfigExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("<" + this.getAuthFieldTypeName() + ">config" + SyntaxKind.DOT_TOKEN.stringValue() + "auth")));
        AssignmentStatementNode httpClientAuthConfigAssignment = NodeFactory.createAssignmentStatementNode((Node)clientConfigAuthRef, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)clientConfigExpr, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        clientConfigAssignmentNodes.add(httpClientAuthConfigAssignment);
        FieldAccessExpressionNode apiKeyConfigNilRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig")));
        SimpleNameReferenceNode apiKeyConfigNilExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"()"));
        AssignmentStatementNode apiKeyConfigNilAssignment = NodeFactory.createAssignmentStatementNode((Node)apiKeyConfigNilRef, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)apiKeyConfigNilExpr, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        clientConfigAssignmentNodes.add(apiKeyConfigNilAssignment);
        NodeList elseBodyNodeList = NodeFactory.createNodeList(clientConfigAssignmentNodes);
        BlockStatementNode elseBodyStatement = NodeFactory.createBlockStatementNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)elseBodyNodeList, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        ElseBlockNode elseBody = NodeFactory.createElseBlockNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ELSE_KEYWORD), (StatementNode)elseBodyStatement);
        BinaryExpressionNode condition = NodeFactory.createBinaryExpressionNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)("config" + SyntaxKind.DOT_TOKEN.stringValue() + "auth")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.IS_KEYWORD), (Node)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
        return NodeFactory.createIfElseStatementNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)condition, (BlockStatementNode)ifBody, (Node)elseBody);
    }

    private AnnotationNode getDisplayAnnotationForRecord(String label) {
        ArrayList<SpecificFieldNode> annotFields = new ArrayList<SpecificFieldNode>();
        BasicLiteralNode labelExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + label + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        SpecificFieldNode labelField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"label"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)labelExpr);
        annotFields.add(labelField);
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(annotFields), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SimpleNameReferenceNode annotateReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"display"));
        return NodeFactory.createAnnotationNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotateReference, (MappingConstructorExpressionNode)annotValue);
    }

    private AnnotationNode getDisplayAnnotationForPasswordField() {
        ArrayList<Object> annotFields = new ArrayList<Object>();
        BasicLiteralNode labelExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)"\"\"", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        SpecificFieldNode labelField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"label"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)labelExpr);
        annotFields.add(labelField);
        annotFields.add(NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        BasicLiteralNode kindExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)"\"password\"", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        SpecificFieldNode kindField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"kind"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)kindExpr);
        annotFields.add(kindField);
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(annotFields), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SimpleNameReferenceNode annotateReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"display"));
        return NodeFactory.createAnnotationNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotateReference, (MappingConstructorExpressionNode)annotValue);
    }

    private MetadataNode getMetadataNode(String comment) {
        ArrayList<MarkdownDocumentationLineNode> docs = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc(comment, false));
        MarkdownDocumentationNode authDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)NodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)authDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    private MetadataNode getMetadataNode(String comment, List<AnnotationNode> annotationNodes) {
        ArrayList<MarkdownDocumentationLineNode> docs = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc(comment, false));
        MarkdownDocumentationNode authDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)NodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)authDocumentationNode, (NodeList)NodeFactory.createNodeList(annotationNodes));
    }

    public void setAuthTypes(Map<String, SecurityScheme> securitySchemeMap, OpenAPI openAPI) throws ClientException {
        List servers = openAPI.getServers();
        String url = "";
        if (servers.size() > 0) {
            url = GeneratorUtils.buildUrl(((Server)servers.get(0)).getUrl(), ((Server)servers.get(0)).getVariables());
        }
        for (Map.Entry<String, SecurityScheme> securitySchemeEntry : securitySchemeMap.entrySet()) {
            String schemaType;
            SecurityScheme schemaValue = securitySchemeEntry.getValue();
            if (schemaValue == null || schemaValue.getType() == null) continue;
            block5 : switch (schemaType = schemaValue.getType().name().toLowerCase(Locale.getDefault())) {
                case "http": {
                    this.httpOROAuth = true;
                    String scheme = schemaValue.getScheme();
                    if (scheme.equals("basic")) {
                        this.authTypes.add("basic");
                        break;
                    }
                    if (!scheme.equals("bearer")) break;
                    this.authTypes.add("bearer");
                    break;
                }
                case "oauth2": {
                    this.httpOROAuth = true;
                    if (schemaValue.getFlows().getClientCredentials() != null) {
                        if (schemaValue.getFlows().getClientCredentials().getTokenUrl() != null) {
                            this.clientCredGrantTokenUrl = schemaValue.getFlows().getClientCredentials().getTokenUrl();
                            if (this.clientCredGrantTokenUrl.startsWith("/")) {
                                this.clientCredGrantTokenUrl = url + this.clientCredGrantTokenUrl;
                            }
                        }
                        this.authTypes.add("client_cred");
                    }
                    if (schemaValue.getFlows().getPassword() != null) {
                        if (schemaValue.getFlows().getPassword().getTokenUrl() != null) {
                            this.passwordGrantTokenUrl = schemaValue.getFlows().getPassword().getTokenUrl();
                            if (this.passwordGrantTokenUrl.startsWith("/")) {
                                this.passwordGrantTokenUrl = url + this.passwordGrantTokenUrl;
                            }
                        }
                        this.authTypes.add("password");
                    }
                    if (schemaValue.getFlows().getAuthorizationCode() != null) {
                        if (schemaValue.getFlows().getAuthorizationCode().getTokenUrl() != null) {
                            this.refreshTokenUrl = schemaValue.getFlows().getAuthorizationCode().getTokenUrl();
                            if (this.refreshTokenUrl.startsWith("/")) {
                                this.refreshTokenUrl = url + this.refreshTokenUrl;
                            }
                        }
                        this.authTypes.addAll(Arrays.asList("bearer", "refresh_token"));
                    }
                    if (schemaValue.getFlows().getImplicit() == null) break;
                    this.authTypes.add("bearer");
                    break;
                }
                case "apikey": {
                    this.apiKey = true;
                    String apiKeyType = schemaValue.getIn().name().toLowerCase(Locale.getDefault());
                    this.authTypes.add("apikey");
                    this.setApiKeysConfigRecordFields(schemaValue);
                    switch (apiKeyType) {
                        case "query": {
                            String actualName = schemaValue.getName();
                            String name = GeneratorUtils.getBallerinaNameExtension(schemaValue.getExtensions()).orElse(actualName);
                            String displayName = GeneratorUtils.escapeIdentifier(name);
                            ApiKeyNamePair queryApiKeyNamePair = new ApiKeyNamePair(actualName, displayName);
                            this.queryApiKeyNameMap.put(securitySchemeEntry.getKey(), queryApiKeyNamePair);
                            break block5;
                        }
                        case "header": {
                            String actualHeaderName = schemaValue.getName();
                            String headerName = GeneratorUtils.getBallerinaNameExtension(schemaValue.getExtensions()).orElse(actualHeaderName);
                            String displayHeaderName = GeneratorUtils.escapeIdentifier(headerName);
                            ApiKeyNamePair headerApiKeyNamePair = new ApiKeyNamePair(actualHeaderName, displayHeaderName);
                            this.headerApiKeyNameMap.put(securitySchemeEntry.getKey(), headerApiKeyNamePair);
                            break block5;
                        }
                    }
                }
            }
        }
        if (!this.apiKey && !this.httpOROAuth) {
            throw new ClientException("Unsupported type of security schema");
        }
    }

    private void setApiKeysConfigRecordFields(SecurityScheme securityScheme) {
        MetadataNode metadataNode = null;
        if (securityScheme.getDescription() != null) {
            List<AnnotationNode> annotationNodes = Collections.singletonList(this.getDisplayAnnotationForPasswordField());
            metadataNode = this.getMetadataNode(securityScheme.getDescription(), annotationNodes);
        }
        SimpleNameReferenceNode stringTypeDesc = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        String name = GeneratorUtils.getBallerinaNameExtension(securityScheme.getExtensions()).orElse(securityScheme.getName());
        IdentifierToken apiKeyName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(name));
        this.apiKeysConfigRecordFields.add((Node)NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)stringTypeDesc, (Token)apiKeyName, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
    }

    private String getAuthFieldTypeName() {
        HashSet<String> httpFieldTypeNames = new HashSet<String>();
        Iterator<String> iterator = this.authTypes.iterator();
        while (iterator.hasNext()) {
            String authType;
            switch (authType = iterator.next()) {
                case "bearer": {
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.BEARER.getValue());
                    break;
                }
                case "basic": {
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.BASIC.getValue());
                    break;
                }
                case "client_cred": {
                    if (this.clientCredGrantTokenUrl != null && !this.clientCredGrantTokenUrl.isBlank()) {
                        httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CUSTOM_CLIENT_CREDENTIAL.getValue());
                        break;
                    }
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CLIENT_CREDENTIAL.getValue());
                    break;
                }
                case "password": {
                    if (this.passwordGrantTokenUrl != null && !this.passwordGrantTokenUrl.isBlank()) {
                        httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CUSTOM_PASSWORD.getValue());
                        break;
                    }
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.PASSWORD.getValue());
                    break;
                }
                case "refresh_token": {
                    if (this.refreshTokenUrl != null && !this.refreshTokenUrl.isBlank()) {
                        httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CUSTOM_REFRESH_TOKEN.getValue());
                        break;
                    }
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.REFRESH_TOKEN.getValue());
                    break;
                }
            }
        }
        return this.buildConfigRecordFieldTypes(httpFieldTypeNames).toString();
    }

    private StringBuilder buildConfigRecordFieldTypes(Set<String> fieldtypes) {
        StringBuilder httpAuthFieldTypes = new StringBuilder();
        if (!fieldtypes.isEmpty()) {
            for (String fieldType : fieldtypes) {
                if (httpAuthFieldTypes.length() != 0) {
                    httpAuthFieldTypes.append("|").append(fieldType);
                    continue;
                }
                httpAuthFieldTypes.append(fieldType);
            }
        }
        return httpAuthFieldTypes;
    }

    public record ApiKeyNamePair(String actualName, String displayName) {
    }
}

