/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.FunctionReturnTypeGeneratorImp;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class FunctionStatusCodeReturnTypeGenerator
extends FunctionReturnTypeGeneratorImp {
    private final String path;
    private final BallerinaUtilGenerator ballerinaUtilGenerator;
    private boolean hasDefaultStatusCodeBinding = false;
    private List<String> nonDefaultStatusCodes = new ArrayList<String>();

    public FunctionStatusCodeReturnTypeGenerator(Operation operation, OpenAPI openAPI, String httpMethod, String path, BallerinaUtilGenerator ballerinaUtilGenerator) {
        super(operation, openAPI, httpMethod);
        this.path = path;
        this.ballerinaUtilGenerator = ballerinaUtilGenerator;
    }

    @Override
    protected boolean populateReturnType(String statusCode, ApiResponse response, List<TypeDescriptorNode> returnTypes, HashSet<String> returnTypesSet) {
        try {
            String code = GeneratorConstants.HTTP_CODES_DES.get(statusCode);
            if (Objects.isNull(code)) {
                this.diagnostics.add(new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_113, statusCode));
                return false;
            }
            ArrayList<Diagnostic> newDiagnostics = new ArrayList<Diagnostic>();
            returnTypes.add(GeneratorUtils.generateStatusCodeTypeInclusionRecord(code, response, this.httpMethod, this.openAPI, this.path, newDiagnostics));
            if (statusCode.equals("default")) {
                this.hasDefaultStatusCodeBinding = true;
                if (!this.ballerinaUtilGenerator.hasDefaultStatusCodeResponseBinding()) {
                    this.ballerinaUtilGenerator.setDefaultStatusCodeResponseBinding(true);
                }
            } else {
                this.nonDefaultStatusCodes.add(statusCode);
            }
            this.diagnostics.addAll(newDiagnostics.stream().map(ClientDiagnosticImp::new).toList());
        }
        catch (InvalidReferenceException e) {
            this.diagnostics.add(new ClientDiagnosticImp(e.getDiagnostic()));
        }
        return false;
    }

    @Override
    public boolean hasDefaultStatusCodeBinding() {
        return this.hasDefaultStatusCodeBinding;
    }

    @Override
    public List<String> getNonDefaultStatusCodes() {
        return this.nonDefaultStatusCodes;
    }
}

