/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.openapi.core.generators.client.AuthConfigGeneratorImp;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.FunctionBodyGeneratorImp;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.List;
import java.util.Map;

public class ImplFunctionBodyGenerator
extends FunctionBodyGeneratorImp {
    private final boolean hasDefaultStatusResponse;
    private final List<String> nonDefaultStatusCodes;

    public ImplFunctionBodyGenerator(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, AuthConfigGeneratorImp ballerinaAuthConfigGeneratorImp, BallerinaUtilGenerator ballerinaUtilGenerator, List<ImportDeclarationNode> imports, boolean hasHeaders, boolean hasDefaultHeaders, boolean hasQueries, String headersParamName, boolean hasDefaultResponse, List<String> nonDefaultStatusCodes) {
        super(path, operation, openAPI, ballerinaAuthConfigGeneratorImp, ballerinaUtilGenerator, imports, hasHeaders, hasDefaultHeaders, hasQueries, headersParamName);
        this.hasDefaultStatusResponse = hasDefaultResponse;
        this.nonDefaultStatusCodes = nonDefaultStatusCodes;
    }

    @Override
    protected String getClientCallWithHeadersParam() {
        return this.addTargetTypeParam(super.getClientCallWithHeadersParam());
    }

    @Override
    protected String getClientCallWithRequestAndHeaders() {
        return this.addTargetTypeParam(super.getClientCallWithRequestAndHeaders());
    }

    @Override
    protected String getClientCallWithHeaders() {
        return this.addTargetTypeParam(super.getClientCallWithHeaders());
    }

    @Override
    protected String getClientCallWithRequest() {
        return this.addTargetTypeParam(super.getClientCallWithRequest());
    }

    @Override
    protected String getSimpleClientCall() {
        return this.addTargetTypeParam(super.getSimpleClientCall());
    }

    @Override
    protected void generateReturnStatement(List<StatementNode> statementsList, String returnStatement) {
        if (this.hasDefaultStatusResponse) {
            String responseVarExp = "var response = " + returnStatement;
            ExpressionStatementNode responseStatement = GeneratorUtils.getSimpleExpressionStatementNode(responseVarExp);
            statementsList.add((StatementNode)responseStatement);
            String nonDefaultStatusCodeList = this.nonDefaultStatusCodes.isEmpty() ? "[]" : "[" + String.join((CharSequence)", ", this.nonDefaultStatusCodes) + "]";
            String nonDefaultStatusCodesExp = "int[] nonDefaultStatusCodes = " + nonDefaultStatusCodeList;
            ExpressionStatementNode nonDefaultStatusCodesStatement = GeneratorUtils.getSimpleExpressionStatementNode(nonDefaultStatusCodesExp);
            statementsList.add((StatementNode)nonDefaultStatusCodesStatement);
            returnStatement = "getValidatedResponseForDefaultMapping(response, nonDefaultStatusCodes)";
        }
        super.generateReturnStatement(statementsList, returnStatement);
    }

    private String addTargetTypeParam(String clientCall) {
        String substring = clientCall.substring(0, clientCall.length() - 1);
        return substring + ", targetType = targetType)";
    }
}

