/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.InferredTypedescDefaultNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.FunctionExternalReturnTypeGenerator;
import io.ballerina.openapi.core.generators.client.FunctionReturnTypeGeneratorImp;
import io.ballerina.openapi.core.generators.client.FunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.RemoteFunctionSignatureGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Objects;

public class RemoteExternalFunctionSignatureGenerator
extends RemoteFunctionSignatureGenerator {
    public RemoteExternalFunctionSignatureGenerator(Operation operation, OpenAPI openAPI, String httpMethod, String path, BallerinaUtilGenerator ballerinaUtilGenerator) {
        super(operation, openAPI, httpMethod, path);
        this.functionReturnTypeGenerator = new FunctionExternalReturnTypeGenerator(operation, openAPI, httpMethod, path, ballerinaUtilGenerator);
    }

    @Override
    protected FunctionSignatureGenerator.ParametersInfo getParametersInfo(List<Parameter> parameters) {
        List<TypeDescriptorNode> returnTypes;
        FunctionSignatureGenerator.ParametersInfo parametersInfo = super.getParametersInfo(parameters);
        if (parametersInfo == null) {
            return null;
        }
        FunctionReturnTypeGeneratorImp functionReturnTypeGenerator = this.getFunctionReturnTypeGenerator();
        FunctionReturnTypeGeneratorImp.ReturnTypesInfo returnTypeInfo = functionReturnTypeGenerator.getAlreadyDefinedReturnTypeInfo();
        if (Objects.isNull(returnTypeInfo)) {
            returnTypeInfo = functionReturnTypeGenerator.getReturnTypeInfo();
        }
        if ((returnTypes = returnTypeInfo.types()).isEmpty()) {
            this.diagnostics.add(new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_114, this.operation.getOperationId()));
            return null;
        }
        TypeDescriptorNode returnType = FunctionReturnTypeGeneratorImp.createUnionReturnType(returnTypes);
        TypeParameterNode returnTypeParam = NodeFactory.createTypeParameterNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN), (TypeDescriptorNode)returnType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN));
        ParameterizedTypeDescriptorNode targetType = NodeFactory.createParameterizedTypeDescriptorNode((SyntaxKind)SyntaxKind.TYPEDESC_TYPE_DESC, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPEDESC_KEYWORD), (TypeParameterNode)returnTypeParam);
        return this.populateTargetTypeParam((TypeDescriptorNode)targetType, parametersInfo);
    }

    protected FunctionSignatureGenerator.ParametersInfo populateTargetTypeParam(TypeDescriptorNode targetType, FunctionSignatureGenerator.ParametersInfo parametersInfo) {
        InferredTypedescDefaultNode inferredToken = NodeFactory.createInferredTypedescDefaultNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN));
        DefaultableParameterNode targetTypeParam = NodeFactory.createDefaultableParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)targetType, (Token)AbstractNodeFactory.createIdentifierToken((String)"targetType"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)inferredToken);
        parametersInfo.defaultableParams().add((Node)targetTypeParam);
        parametersInfo.defaultableParams().add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        return parametersInfo;
    }
}

