/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.mime;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.openapi.core.generators.client.mime.MimeType;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.List;
import java.util.Map;

public class XmlType
extends MimeType {
    private final List<ImportDeclarationNode> imports;

    public XmlType(List<ImportDeclarationNode> imports) {
        this.imports = imports;
    }

    @Override
    public void setPayload(List<StatementNode> statementsList, Map.Entry<String, MediaType> mediaTypeEntry) {
        GeneratorUtils.addImport(this.imports, "data.xmldata");
        GeneratorUtils.addImport(this.imports, "data.jsondata");
        String payloadName = "xmlBody";
        VariableDeclarationNode jsonVariable = GeneratorUtils.getSimpleStatement("json", "jsonBody", "jsondata:toJson(payload)");
        statementsList.add((StatementNode)jsonVariable);
        VariableDeclarationNode xmlBody = GeneratorUtils.getSimpleStatement("xml?", payloadName, "check xmldata:fromJson(jsonBody)");
        statementsList.add((StatementNode)xmlBody);
        this.setPayload(statementsList, payloadName, mediaTypeEntry.getKey());
    }
}

