/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.model;

import io.ballerina.openapi.core.generators.common.model.Filter;
import io.swagger.v3.oas.models.OpenAPI;

public class OASClientConfig {
    private final OpenAPI openAPI;
    private final Filter filter;
    private final boolean nullable;
    private final boolean resourceMode;
    private final boolean isPlugin;
    private final String license;
    private final boolean statusCodeBinding;
    private final boolean isMock;
    private final boolean singleFile;
    private final boolean isUsingSanitizedOas;

    private OASClientConfig(Builder clientConfigBuilder) {
        this.openAPI = clientConfigBuilder.openAPI;
        this.filter = clientConfigBuilder.filter;
        this.nullable = clientConfigBuilder.nullable;
        this.isPlugin = clientConfigBuilder.isPlugin;
        this.resourceMode = clientConfigBuilder.resourceMode;
        this.license = clientConfigBuilder.license;
        this.statusCodeBinding = clientConfigBuilder.statusCodeBinding;
        this.isMock = clientConfigBuilder.isMock;
        this.singleFile = clientConfigBuilder.singleFile;
        this.isUsingSanitizedOas = clientConfigBuilder.isUsingSanitizedOas;
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isResourceMode() {
        return this.resourceMode;
    }

    public boolean isPlugin() {
        return this.isPlugin;
    }

    public String getLicense() {
        return this.license;
    }

    public boolean isStatusCodeBinding() {
        return this.statusCodeBinding;
    }

    public boolean isMock() {
        return this.isMock;
    }

    public boolean singleFile() {
        return this.singleFile;
    }

    public boolean isUsingSanitizedOas() {
        return this.isUsingSanitizedOas;
    }

    public static class Builder {
        private OpenAPI openAPI;
        private Filter filter = new Filter();
        private boolean nullable = false;
        private boolean resourceMode = true;
        private boolean isPlugin = false;
        private String license = "// AUTO-GENERATED FILE. DO NOT MODIFY.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n";
        private boolean statusCodeBinding = false;
        private boolean isMock = false;
        private boolean singleFile = false;
        private boolean isUsingSanitizedOas = false;

        public Builder withOpenAPI(OpenAPI openAPI) {
            this.openAPI = openAPI;
            return this;
        }

        public Builder withFilters(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder withResourceMode(boolean resourceMode) {
            this.resourceMode = resourceMode;
            return this;
        }

        public Builder withPlugin(boolean isPlugin) {
            this.isPlugin = isPlugin;
            return this;
        }

        public Builder withLicense(String license) {
            this.license = license;
            return this;
        }

        public Builder withStatusCodeBinding(boolean statusCodeBinding) {
            this.statusCodeBinding = statusCodeBinding;
            return this;
        }

        public Builder withMock(boolean isMock) {
            this.isMock = isMock;
            return this;
        }

        public Builder withSingleFile(boolean singleFile) {
            this.singleFile = singleFile;
            return this;
        }

        public Builder withIsUsingSanitizedOas(boolean isUsingSanitizedOas) {
            this.isUsingSanitizedOas = isUsingSanitizedOas;
            return this;
        }

        public OASClientConfig build() {
            return new OASClientConfig(this);
        }
    }
}

