/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.parameter.ParameterGenerator;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PathParameterGenerator
implements ParameterGenerator {
    Parameter parameter;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();

    public PathParameterGenerator(Parameter parameter, OpenAPI openAPI) {
        this.parameter = parameter;
    }

    @Override
    public Optional<ParameterNode> generateParameterNode() {
        IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(this.parameter.getName()));
        Schema parameterSchema = this.parameter.getSchema();
        Optional<TypeDescriptorNode> typeNode = TypeHandler.getInstance().getTypeNodeFromOASSchema(parameterSchema, true);
        if (typeNode.isEmpty()) {
            this.diagnostics.add(new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_101, this.parameter.getName()));
            return Optional.empty();
        }
        TypeDescriptorNode typeDescNode = typeNode.get();
        if (typeDescNode.kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC) || typeDescNode.kind().equals((Object)SyntaxKind.RECORD_TYPE_DESC)) {
            ClientDiagnosticImp diagnostic = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_101, this.parameter.getName());
            this.diagnostics.add(diagnostic);
            return Optional.empty();
        }
        return Optional.of(NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)typeDescNode, (Token)paramName));
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

