/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.client.parameter.ParameterGenerator;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueriesParameterGenerator
implements ParameterGenerator {
    private final List<Parameter> parameters;
    private final OpenAPI openAPI;
    private final List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    private final Operation operation;
    private final String httpMethod;
    private final String path;
    private boolean hasErrors = false;

    public QueriesParameterGenerator(List<Parameter> parameters, OpenAPI openAPI, Operation operation, String httpMethod, String path) {
        this.parameters = parameters;
        this.openAPI = openAPI;
        this.operation = operation;
        this.httpMethod = httpMethod;
        this.path = path;
    }

    @Override
    public Optional<ParameterNode> generateParameterNode() {
        if (this.parameters.isEmpty()) {
            return Optional.empty();
        }
        ObjectSchema queriesSchema = this.getQueriesSchema();
        if (Objects.isNull(queriesSchema)) {
            return Optional.empty();
        }
        String operationId = GeneratorUtils.generateOperationUniqueId(this.operation, this.path, this.httpMethod);
        queriesSchema.setDescription("Represents the Queries record for the operation: " + operationId);
        String queriesName = GeneratorUtils.getValidName(operationId, true) + "Queries";
        this.openAPI.getComponents().addSchemas(queriesName, (Schema)queriesSchema);
        Schema queriesRefSchema = new ObjectSchema().$ref(queriesName);
        Optional<TypeDescriptorNode> queriesType = TypeHandler.getInstance().getTypeNodeFromOASSchema(queriesRefSchema, true);
        return queriesType.map(typeDescriptorNode -> NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createIdentifierToken((String)"queries")));
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private ObjectSchema getQueriesSchema() {
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        for (Parameter parameter2 : this.parameters) {
            properties.put(parameter2.getName(), this.getSchemaWithDetails(parameter2));
        }
        properties.entrySet().removeIf(entry -> {
            if (Objects.isNull(entry.getValue())) {
                ClientDiagnosticImp diagnostic = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_102, (String)entry.getKey());
                this.diagnostics.add(diagnostic);
                this.hasErrors = true;
                return true;
            }
            return false;
        });
        if (properties.isEmpty()) {
            return null;
        }
        ArrayList<String> requiredFields = new ArrayList<String>(this.parameters.stream().filter(parameter -> Boolean.TRUE.equals(parameter.getRequired())).map(Parameter::getName).toList());
        requiredFields.removeIf(field -> !properties.containsKey(field));
        ObjectSchema queriesSchema = new ObjectSchema();
        queriesSchema.setProperties(properties);
        if (!requiredFields.isEmpty()) {
            queriesSchema.setRequired(requiredFields);
        }
        return queriesSchema;
    }
}

