/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.common;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.constraint.ConstraintGeneratorImp;
import io.ballerina.openapi.core.generators.constraint.ConstraintResult;
import io.ballerina.openapi.core.generators.document.DocCommentGeneratorImp;
import io.ballerina.openapi.core.generators.type.BallerinaTypesGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.ballerina.openapi.core.generators.type.model.TypeGeneratorResult;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TypeHandler {
    private static TypeHandler typeHandlerInstance;
    private static BallerinaTypesGenerator ballerinaTypesGenerator;
    private HashMap<String, TypeDefinitionNode> typeDefinitionNodes = new HashMap();
    private final Set<String> imports = new LinkedHashSet<String>();
    private static List<Diagnostic> constraintDiagnostics;

    private TypeHandler() {
    }

    public static void createInstance(OpenAPI openAPI, boolean isNullable) {
        typeHandlerInstance = new TypeHandler();
        ballerinaTypesGenerator = new BallerinaTypesGenerator(openAPI, isNullable);
        constraintDiagnostics = new ArrayList<Diagnostic>();
        GeneratorUtils.initializeRecordCountMap();
    }

    public static TypeHandler getInstance() {
        return typeHandlerInstance;
    }

    public List<Diagnostic> getDiagnostics() {
        constraintDiagnostics.addAll(ballerinaTypesGenerator.getDiagnostics());
        return constraintDiagnostics;
    }

    public void addTypeDefinitionNode(String key, TypeDefinitionNode typeDefinitionNode) {
        this.typeDefinitionNodes.put(key, typeDefinitionNode);
    }

    public void addImport(String importValue) {
        this.imports.add(importValue);
    }

    public SyntaxTree generateTypeSyntaxTree() {
        NodeList<ModuleMemberDeclarationNode> typeMembers = this.getTypeMembers();
        NodeList<ImportDeclarationNode> imports = this.generateImportNodes();
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, typeMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        syntaxTree = syntaxTree.modifyWith((Node)modulePartNode);
        DocCommentGeneratorImp docCommentGenerator = new DocCommentGeneratorImp(GeneratorMetaData.getInstance().getOpenAPI(), syntaxTree, GenSrcFile.GenFileType.GEN_TYPE, false);
        return docCommentGenerator.updateSyntaxTreeWithDocComments();
    }

    private NodeList<ModuleMemberDeclarationNode> getTypeMembers() {
        if (!GeneratorMetaData.getInstance().isNullable()) {
            ConstraintGeneratorImp constraintGenerator = new ConstraintGeneratorImp(GeneratorMetaData.getInstance().getOpenAPI(), this.typeDefinitionNodes);
            ConstraintResult constraintResult = constraintGenerator.updateTypeDefinitionsWithConstraints();
            this.typeDefinitionNodes = constraintResult.typeDefinitionNodeHashMap();
            boolean isConstraintAvailable = constraintResult.isConstraintAvailable();
            if (isConstraintAvailable) {
                this.imports.add("import ballerina/constraint;");
            }
            constraintDiagnostics.addAll(constraintResult.diagnostics());
        }
        return AbstractNodeFactory.createNodeList((Node[])((ModuleMemberDeclarationNode[])this.typeDefinitionNodes.values().toArray(new TypeDefinitionNode[this.typeDefinitionNodes.size()])));
    }

    private NodeList<ImportDeclarationNode> generateImportNodes() {
        LinkedHashSet<ImportDeclarationNode> importDeclarationNodes = new LinkedHashSet<ImportDeclarationNode>();
        if (!this.typeDefinitionNodes.isEmpty()) {
            this.importsForTypeDefinitions(this.imports);
        }
        if (!this.imports.isEmpty()) {
            for (String importValue : this.imports) {
                ImportDeclarationNode importDeclarationNode = NodeParser.parseImportDeclaration((String)importValue);
                importDeclarationNodes.add(importDeclarationNode);
            }
        }
        if (importDeclarationNodes.isEmpty()) {
            return AbstractNodeFactory.createEmptyNodeList();
        }
        return AbstractNodeFactory.createNodeList(importDeclarationNodes);
    }

    private void importsForTypeDefinitions(Set<String> imports) {
        block0: for (TypeDefinitionNode node : this.typeDefinitionNodes.values()) {
            if (!(node.typeDescriptor() instanceof RecordTypeDescriptorNode)) continue;
            if (node.typeName().text().equals("ConnectionConfig")) {
                imports.add("import ballerina/http;");
            }
            RecordTypeDescriptorNode record = (RecordTypeDescriptorNode)node.typeDescriptor();
            for (Node field : record.fields()) {
                TypeReferenceNode recordField;
                QualifiedNameReferenceNode typeInclusion;
                if (!(field instanceof TypeReferenceNode) || !(((TypeReferenceNode)field).typeName() instanceof QualifiedNameReferenceNode) || !(typeInclusion = (QualifiedNameReferenceNode)(recordField = (TypeReferenceNode)field).typeName()).modulePrefix().text().equals("http")) continue;
                imports.add("import ballerina/http;");
                continue block0;
            }
        }
    }

    public Optional<TypeDescriptorNode> getTypeNodeFromOASSchema(Schema schema) {
        return this.getTypeNodeFromOASSchema(schema, false);
    }

    public Optional<TypeDescriptorNode> getTypeNodeFromOASSchema(Schema schema, boolean ignoreNullableFlag) {
        TypeGeneratorResult typeGeneratorResult = ballerinaTypesGenerator.generateTypeDescriptorNodeForOASSchema(schema, ignoreNullableFlag);
        this.handleSubtypes(typeGeneratorResult.subtypeDefinitions());
        return typeGeneratorResult.typeDescriptorNode();
    }

    public TypeDescriptorNode generateHeaderType(Schema headersSchema) {
        return this.getTypeNodeFromOASSchema(headersSchema).orElse(null);
    }

    public NameReferenceNode createTypeInclusionRecord(String statusCode, TypeDescriptorNode bodyType, TypeDescriptorNode headersType, String method) {
        Object recordName;
        String statusCodeName;
        String string = statusCodeName = statusCode.equals("DefaultStatusCodeResponse") ? "Default" : statusCode;
        if (Objects.isNull(bodyType) && Objects.isNull(headersType)) {
            return GeneratorUtils.getQualifiedNameReferenceNode("http", statusCode);
        }
        if (Objects.nonNull(bodyType)) {
            String bodyTypeStr = bodyType.toString().replaceAll("[\\[\\\\]]", "Array");
            recordName = GeneratorUtils.getValidName(bodyTypeStr, true) + statusCodeName;
        } else {
            recordName = statusCodeName;
        }
        RecordTypeDescriptorNode recordTypeDescriptorNode = TypeHandler.getRecordTypeDescriptorNode(statusCode, bodyType, headersType);
        if (this.typeDefinitionNodes.containsKey(recordName) && Objects.nonNull(this.typeDefinitionNodes.get(recordName).typeDescriptor())) {
            if (this.typeDefinitionNodes.get(recordName).typeDescriptor().toSourceCode().equals(recordTypeDescriptorNode.toSourceCode())) {
                return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)recordName));
            }
            recordName = method.substring(0, 1).toUpperCase(Locale.ROOT) + method.substring(1) + (String)recordName;
        }
        TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)recordName), (Node)recordTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        this.typeDefinitionNodes.put((String)recordName, typeDefinitionNode);
        return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)recordName));
    }

    private static RecordTypeDescriptorNode getRecordTypeDescriptorNode(String statusCode, TypeDescriptorNode bodyType, TypeDescriptorNode headersType) {
        Token recordKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD);
        IdentifierToken bodyStartDelimiter = AbstractNodeFactory.createIdentifierToken((String)"{|");
        ArrayList<Object> recordFields = new ArrayList<Object>();
        IdentifierToken asteriskToken = AbstractNodeFactory.createIdentifierToken((String)"*");
        QualifiedNameReferenceNode typeNameField = GeneratorUtils.getQualifiedNameReferenceNode("http", statusCode);
        TypeReferenceNode typeReferenceNode = NodeFactory.createTypeReferenceNode((Token)asteriskToken, (Node)typeNameField, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        recordFields.add(typeReferenceNode);
        IdentifierToken bodyFieldName = AbstractNodeFactory.createIdentifierToken((String)"body", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        if (bodyType != null) {
            RecordFieldNode bodyFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)bodyType, (Token)bodyFieldName, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            recordFields.add(bodyFieldNode);
        }
        if (headersType != null) {
            IdentifierToken headersFieldName = AbstractNodeFactory.createIdentifierToken((String)"headers", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
            RecordFieldNode headersFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)headersType, (Token)headersFieldName, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            recordFields.add(headersFieldNode);
        }
        SeparatedNodeList fieldsList = AbstractNodeFactory.createSeparatedNodeList(recordFields);
        IdentifierToken bodyEndDelimiter = AbstractNodeFactory.createIdentifierToken((String)"|}");
        return NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldsList, null, (Token)bodyEndDelimiter);
    }

    private void handleSubtypes(HashMap<String, TypeDefinitionNode> subTypesMap) {
        if (!subTypesMap.isEmpty()) {
            subTypesMap.forEach((recordName, typeDefinitionNode) -> {
                if (!this.typeDefinitionNodes.containsKey(recordName)) {
                    this.typeDefinitionNodes.put(typeDefinitionNode.typeName().text(), (TypeDefinitionNode)typeDefinitionNode);
                }
            });
        }
    }
}

