/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.document;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.document.DocCommentsGenerator;
import io.ballerina.openapi.core.generators.document.DocCommentsGeneratorUtil;
import io.ballerina.openapi.core.generators.document.OperationDetails;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ServiceDocCommentGenerator
implements DocCommentsGenerator {
    OpenAPI openAPI;
    SyntaxTree syntaxTree;

    public ServiceDocCommentGenerator(SyntaxTree syntaxTree, OpenAPI openAPI, boolean isProxyService) {
        this.openAPI = openAPI;
        this.syntaxTree = syntaxTree;
    }

    @Override
    public SyntaxTree updateSyntaxTreeWithDocComments() {
        HashMap<String, OperationDetails> operationDetailsMap = new HashMap<String, OperationDetails>();
        Paths paths = this.openAPI.getPaths();
        this.extractOperations(operationDetailsMap, paths);
        Node rootNode = this.syntaxTree.rootNode();
        ModulePartNode modulePartNode = (ModulePartNode)rootNode;
        NodeList members = modulePartNode.members();
        ArrayList updatedMembers = new ArrayList();
        members.forEach(member -> {
            if (member.kind().equals((Object)SyntaxKind.SERVICE_DECLARATION)) {
                ServiceDeclarationNode classDef = (ServiceDeclarationNode)member;
                HashMap updatedList = new HashMap();
                NodeList classMembers = classDef.members();
                ArrayList sortedMembers = new ArrayList();
                ArrayList clientInitNodes = new ArrayList();
                classMembers.forEach(classMember -> {
                    String sortKey = "";
                    if (classMember.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)) {
                        FunctionDefinitionNode funcDef = (FunctionDefinitionNode)classMember;
                        sortKey = funcDef.toSourceCode();
                        sortedMembers.add(sortKey);
                        NodeList nodes = funcDef.relativeResourcePath();
                        StringBuilder path = new StringBuilder();
                        for (Node node : nodes) {
                            path.append(node.toString().replace("\"", ""));
                        }
                        String key = GeneratorUtils.replaceContentWithinBrackets(path.toString(), "XXX") + "_" + funcDef.functionName().text();
                        funcDef = this.updateDocCommentsForFunctionNode(operationDetailsMap, funcDef, key);
                        classMember = funcDef;
                    } else {
                        clientInitNodes.add(classMember);
                    }
                    updatedList.put(sortKey, classMember);
                });
                ArrayList sortedNodes = new ArrayList();
                sortedNodes.addAll(clientInitNodes);
                sortedMembers.sort(String::compareTo);
                for (String memberStr : sortedMembers) {
                    sortedNodes.add((Node)updatedList.get(memberStr));
                }
                member = classDef.modify((MetadataNode)classDef.metadata().orElse(null), classDef.qualifiers(), classDef.serviceKeyword(), (TypeDescriptorNode)classDef.typeDescriptor().orElse(null), classDef.absoluteResourcePath(), classDef.onKeyword(), classDef.expressions(), classDef.openBraceToken(), updatedList.isEmpty() ? classDef.members() : AbstractNodeFactory.createNodeList(sortedNodes), classDef.closeBraceToken(), (Token)classDef.semicolonToken().orElse(null));
            }
            updatedMembers.add(member);
            NodeList clientMembers = AbstractNodeFactory.createNodeList((Collection)updatedMembers);
            ModulePartNode updatedmodulePartNode = modulePartNode.modify(modulePartNode.imports(), clientMembers, modulePartNode.eofToken());
            this.syntaxTree = this.syntaxTree.modifyWith((Node)updatedmodulePartNode);
        });
        return this.syntaxTree;
    }

    private void extractOperations(HashMap<String, OperationDetails> operationDetailsMap, Paths paths) {
        paths.forEach((path, pathItem) -> {
            for (Map.Entry entry : pathItem.readOperationsMap().entrySet()) {
                PathItem.HttpMethod method = (PathItem.HttpMethod)entry.getKey();
                Operation operation = (Operation)entry.getValue();
                path = path.equals("/") ? "." : path;
                String key = GeneratorUtils.replaceContentWithinBrackets(path.replaceFirst("/", ""), "XXX") + "_" + method.name().toLowerCase(Locale.ENGLISH);
                operationDetailsMap.put(key, new OperationDetails(operation.getOperationId(), operation, (String)path, method.name()));
            }
        });
    }

    private FunctionDefinitionNode updateDocCommentsForFunctionNode(HashMap<String, OperationDetails> operationDetailsMap, FunctionDefinitionNode funcDef, String key) {
        OperationDetails operationDetails = operationDetailsMap.get(key);
        if (operationDetails != null) {
            MetadataNode metadataNode;
            RequestBody requestBody;
            ArrayList<Node> docs = new ArrayList<Node>();
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            Operation operation = operationDetails.operation();
            if (operation.getSummary() != null) {
                docs.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(operation.getSummary(), true));
            } else if (operation.getDescription() != null) {
                docs.addAll(DocCommentsGeneratorUtil.createAPIDescriptionDoc(operation.getDescription(), true));
            }
            if (operation.getExtensions() != null) {
                DocCommentsGeneratorUtil.extractDisplayAnnotation(operation.getExtensions(), annotations);
            }
            FunctionSignatureNode functionSignatureNode = funcDef.functionSignature();
            if (operation.getParameters() != null) {
                SeparatedNodeList parameters = functionSignatureNode.parameters();
                ArrayList<Node> updatedParamsRequired = new ArrayList<Node>();
                ArrayList<Node> updatedParamsDefault = new ArrayList<Node>();
                HashMap<String, ParameterNode> collection = ServiceDocCommentGenerator.getParameterNodeHashMap((SeparatedNodeList<ParameterNode>)parameters);
                ServiceDocCommentGenerator.updateParameterNodes(docs, this.openAPI, operation, updatedParamsRequired, updatedParamsDefault, collection);
                updatedParamsRequired.addAll(updatedParamsDefault);
                if (!updatedParamsRequired.isEmpty()) {
                    updatedParamsRequired.remove(updatedParamsRequired.size() - 1);
                    functionSignatureNode = functionSignatureNode.modify(functionSignatureNode.openParenToken(), AbstractNodeFactory.createSeparatedNodeList(updatedParamsRequired), functionSignatureNode.closeParenToken(), (ReturnTypeDescriptorNode)functionSignatureNode.returnTypeDesc().orElse(null));
                }
            }
            if ((requestBody = operation.getRequestBody()) != null) {
                this.requestBodyDoc(docs, requestBody);
            }
            if (operation.getResponses() != null) {
                Map.Entry response;
                Optional<String> responseDescription;
                ApiResponses responses = operation.getResponses();
                Set entrySet = responses.entrySet();
                if (entrySet.size() > 1) {
                    MarkdownParameterDocumentationLineNode returnDoc = DocCommentsGeneratorUtil.createAPIParamDoc("return", "returns can be any of following types");
                    docs.add((Node)returnDoc);
                    for (Map.Entry response2 : entrySet) {
                        String code = GeneratorConstants.HTTP_CODES_DES.get(((String)response2.getKey()).trim());
                        Optional<String> responseDescription2 = DocCommentsGeneratorUtil.getResponseDescription((ApiResponse)response2.getValue(), this.openAPI.getComponents());
                        if (!responseDescription2.isPresent()) continue;
                        if (code == null) {
                            code = "Response";
                        }
                        MarkdownCodeLineNode returnDocLine = NodeFactory.createMarkdownCodeLineNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (Token)AbstractNodeFactory.createIdentifierToken((String)String.format("http:%s (%s)", code, responseDescription2.get().replaceAll("\n", "\n# "))));
                        docs.add((Node)returnDocLine);
                    }
                } else if (entrySet.size() == 1 && (responseDescription = DocCommentsGeneratorUtil.getResponseDescription((ApiResponse)(response = (Map.Entry)responses.entrySet().iterator().next()).getValue(), this.openAPI.getComponents())).isPresent()) {
                    MarkdownParameterDocumentationLineNode returnDoc = DocCommentsGeneratorUtil.createAPIParamDoc("return", responseDescription.get());
                    docs.add((Node)returnDoc);
                }
            }
            MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
            Optional metadata = funcDef.metadata();
            metadataNode = metadata.isEmpty() ? NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createNodeList(annotations)) : NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)((metadataNode = (MetadataNode)metadata.get()).annotations().isEmpty() ? AbstractNodeFactory.createNodeList(annotations) : metadataNode.annotations().addAll(annotations)));
            funcDef = funcDef.modify(funcDef.kind(), metadataNode, funcDef.qualifierList(), funcDef.functionKeyword(), funcDef.functionName(), funcDef.relativeResourcePath(), functionSignatureNode, funcDef.functionBody());
        }
        return funcDef;
    }

    private void requestBodyDoc(List<Node> docs, RequestBody requestBody) {
        if (requestBody.get$ref() != null) {
            try {
                requestBody = (RequestBody)this.openAPI.getComponents().getRequestBodies().get(GeneratorUtils.extractReferenceType(requestBody.get$ref()));
            }
            catch (BallerinaOpenApiException e) {
                requestBody = new RequestBody();
            }
        }
        Content content = requestBody.getContent();
        String[] paramName = new String[]{"http:Request"};
        if (content != null) {
            content.entrySet().stream().findFirst().ifPresent(mediaType -> {
                paramName[0] = GeneratorUtils.getBallerinaMediaType((String)mediaType.getKey(), true);
            });
        } else {
            paramName[0] = "http:Request";
        }
        Optional<String> requestBodyDescription = DocCommentsGeneratorUtil.getRequestBodyDescription(requestBody, this.openAPI.getComponents());
        if (requestBodyDescription.isPresent()) {
            String description = requestBodyDescription.get().split("\n")[0];
            docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDoc(paramName[0].equals("http:Request") ? "request" : "payload", description));
        }
    }

    private static void updateParameterNodes(List<Node> docs, OpenAPI openAPI, Operation operation, List<Node> updatedParamsRequired, List<Node> updatedParamsDefault, HashMap<String, ParameterNode> collection) {
        ArrayList deprecatedParamDocComments = new ArrayList();
        operation.getParameters().forEach(parameter -> {
            Optional<String> parameterDescription;
            ArrayList<AnnotationNode> paramAnnot = new ArrayList<AnnotationNode>();
            String parameterName = parameter.getName();
            if (parameter.getIn() != null && (parameter.getIn().equals("path") || parameter.getIn().equals("header") || parameter.getIn().equals("query"))) {
                ParameterNode parameterNode;
                parameterName = GeneratorUtils.escapeIdentifier(parameter.getName());
                if (parameter.getDeprecated() != null && parameter.getDeprecated().booleanValue()) {
                    DocCommentsGeneratorUtil.extractDeprecatedAnnotationDetails(deprecatedParamDocComments, parameter, paramAnnot);
                }
                if (parameter.getExtensions() != null) {
                    DocCommentsGeneratorUtil.extractDisplayAnnotation(parameter.getExtensions(), paramAnnot);
                    parameterNode = (ParameterNode)collection.get(parameterName);
                    ServiceDocCommentGenerator.updatedDisplayAnnotationInParameterNode(updatedParamsRequired, updatedParamsDefault, paramAnnot, parameterNode);
                }
                parameterNode = (ParameterNode)collection.get(parameterName);
                DocCommentsGeneratorUtil.updatedAnnotationInParameterNode(updatedParamsRequired, updatedParamsDefault, paramAnnot, parameterNode);
            }
            if ((parameterDescription = DocCommentsGeneratorUtil.getParameterDescription(parameter, openAPI.getComponents())).isPresent()) {
                docs.add((Node)DocCommentsGeneratorUtil.createAPIParamDocFromString(parameterName, parameterDescription.get()));
            }
        });
    }

    private static HashMap<String, ParameterNode> getParameterNodeHashMap(SeparatedNodeList<ParameterNode> parameters) {
        HashMap<String, ParameterNode> collection = new HashMap<String, ParameterNode>();
        for (ParameterNode node : parameters) {
            if (node instanceof RequiredParameterNode) {
                RequiredParameterNode reParam = (RequiredParameterNode)node;
                collection.put(((Token)reParam.paramName().get()).toString(), (ParameterNode)reParam);
                continue;
            }
            if (!(node instanceof DefaultableParameterNode)) continue;
            DefaultableParameterNode deParam = (DefaultableParameterNode)node;
            collection.put(((Token)deParam.paramName().get()).toString(), (ParameterNode)deParam);
        }
        return collection;
    }

    private static void updatedDisplayAnnotationInParameterNode(List<Node> updatedParamsRequired, List<Node> updatedParamsDefault, List<AnnotationNode> paramAnnot, ParameterNode parameterNode) {
        if (parameterNode != null) {
            if (parameterNode instanceof RequiredParameterNode) {
                RequiredParameterNode reParam;
                updatedParamsRequired.add((Node)reParam.modify((reParam = (RequiredParameterNode)parameterNode).annotations().isEmpty() ? AbstractNodeFactory.createNodeList(paramAnnot) : reParam.annotations().addAll(paramAnnot), reParam.typeName(), (Token)reParam.paramName().orElse(null)));
                updatedParamsRequired.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            } else if (parameterNode instanceof DefaultableParameterNode) {
                DefaultableParameterNode deParam;
                updatedParamsDefault.add((Node)deParam.modify((deParam = (DefaultableParameterNode)parameterNode).annotations().isEmpty() ? AbstractNodeFactory.createNodeList(paramAnnot) : deParam.annotations().addAll(paramAnnot), deParam.typeName(), (Token)deParam.paramName().orElse(null), deParam.equalsToken(), deParam.expression()));
                updatedParamsDefault.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
        }
    }
}

