/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.document.ServiceDocCommentGenerator;
import io.ballerina.openapi.core.generators.service.ListenerGenerator;
import io.ballerina.openapi.core.generators.service.ListenerGeneratorImpl;
import io.ballerina.openapi.core.generators.service.ServiceGenerationUtils;
import io.ballerina.openapi.core.generators.service.ServiceGenerator;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceDeclarationGenerator
extends ServiceGenerator {
    public ServiceDeclarationGenerator(OASServiceMetadata oasServiceMetadata) {
        super(oasServiceMetadata);
        GeneratorMetaData.createInstance(oasServiceMetadata.getOpenAPI(), oasServiceMetadata.isNullable());
    }

    @Override
    public SyntaxTree generateSyntaxTree() throws BallerinaOpenApiException {
        NodeList<ImportDeclarationNode> imports = ServiceGenerationUtils.createImportDeclarationNodes();
        ListenerGeneratorImpl listenerGenerator = new ListenerGeneratorImpl();
        ListenerDeclarationNode listenerDeclarationNode = listenerGenerator.getListenerDeclarationNodes(this.oasServiceMetadata.getOpenAPI().getServers());
        this.diagnostics.addAll(listenerGenerator.getDiagnostics());
        NodeList<Node> absoluteResourcePath = this.createBasePathNodeList(listenerGenerator);
        SimpleNameReferenceNode listenerName = NodeFactory.createSimpleNameReferenceNode((Token)listenerDeclarationNode.variableName());
        SeparatedNodeList expressions = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{listenerName});
        if (this.functionsList == null) {
            this.functionsList = this.createResourceFunctions(this.oasServiceMetadata.getOpenAPI(), this.oasServiceMetadata.getFilters());
        }
        NodeList members = AbstractNodeFactory.createNodeList((Collection)this.functionsList);
        MetadataNode metadataNode = null;
        if (this.isNullableRequired) {
            metadataNode = ServiceGenerationUtils.generateServiceConfigAnnotation();
        }
        SimpleNameReferenceNode serviceType = null;
        if (this.oasServiceMetadata.isServiceTypeRequired()) {
            serviceType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"OASServiceType"));
        }
        ServiceDeclarationNode serviceDeclarationNode = NodeFactory.createServiceDeclarationNode((MetadataNode)metadataNode, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE), (TypeDescriptorNode)serviceType, absoluteResourcePath, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ON_KEYWORD, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE), (SeparatedNodeList)expressions, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)members, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        NodeList moduleMembers = AbstractNodeFactory.createNodeList((Node[])new ModuleMemberDeclarationNode[]{listenerDeclarationNode, serviceDeclarationNode});
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        syntaxTree = syntaxTree.modifyWith((Node)modulePartNode);
        ServiceDocCommentGenerator serviceDocCommentGenerator = new ServiceDocCommentGenerator(syntaxTree, this.oasServiceMetadata.getOpenAPI(), this.oasServiceMetadata.generateWithoutDataBinding());
        return serviceDocCommentGenerator.updateSyntaxTreeWithDocComments();
    }

    private NodeList<Node> createBasePathNodeList(ListenerGenerator listener) {
        if ("/".equals(listener.getBasePath())) {
            return AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)listener.getBasePath())});
        }
        String[] basePathNode = listener.getBasePath().split("/");
        List basePath = Arrays.stream(basePathNode).filter(node -> !node.isBlank()).map(node -> AbstractNodeFactory.createIdentifierToken((String)("/" + GeneratorUtils.escapeIdentifier(node)))).collect(Collectors.toList());
        return AbstractNodeFactory.createNodeList(basePath);
    }
}

