/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.resource.ResourceGenerator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ServiceGenerator {
    final OASServiceMetadata oasServiceMetadata;
    boolean isNullableRequired;
    List<Node> functionsList;
    final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public ServiceGenerator(OASServiceMetadata oasServiceMetadata) {
        this.oasServiceMetadata = oasServiceMetadata;
    }

    public ServiceGenerator(OASServiceMetadata oasServiceMetadata, List<Node> functionsList) {
        this.oasServiceMetadata = oasServiceMetadata;
        this.functionsList = functionsList;
    }

    public abstract SyntaxTree generateSyntaxTree() throws BallerinaOpenApiException;

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public List<Node> getFunctionsList() {
        return this.functionsList;
    }

    List<Node> createResourceFunctions(OpenAPI openApi, Filter filter) {
        ArrayList<Node> functions = new ArrayList<Node>();
        if (!openApi.getPaths().isEmpty()) {
            Paths paths = openApi.getPaths();
            Set pathsItems = paths.entrySet();
            for (Map.Entry path : pathsItems) {
                if (((PathItem)path.getValue()).readOperationsMap().isEmpty()) continue;
                Map operationMap = ((PathItem)path.getValue()).readOperationsMap();
                functions.addAll(this.applyFiltersForOperations(filter, (String)path.getKey(), operationMap));
            }
        }
        return functions;
    }

    private List<Node> applyFiltersForOperations(Filter filter, String path, Map<PathItem.HttpMethod, Operation> operationMap) {
        ArrayList<Node> functions = new ArrayList<Node>();
        for (Map.Entry<PathItem.HttpMethod, Operation> operation : operationMap.entrySet()) {
            List<String> filterTags = filter.getTags();
            List operationTags = operation.getValue().getTags();
            List<String> filterOperations = filter.getOperations();
            ResourceGenerator resourceGenerator = ResourceGenerator.createResourceGenerator(this.oasServiceMetadata);
            if (!filterTags.isEmpty() || !filterOperations.isEmpty()) {
                if ((operationTags != null || !filterOperations.isEmpty() && operation.getValue().getOperationId() != null) && (operationTags != null && GeneratorUtils.hasTags(operationTags, filterTags) || operation.getValue().getOperationId() != null && filterOperations.contains(operation.getValue().getOperationId().trim()))) {
                    try {
                        resourceFunction = resourceGenerator.generateResourceFunction(operation, path);
                    }
                    catch (BallerinaOpenApiException e) {
                        this.diagnostics.add(e.getDiagnostic());
                        continue;
                    }
                    this.diagnostics.addAll(resourceGenerator.getDiagnostics());
                    functions.add((Node)resourceFunction);
                }
            } else {
                try {
                    resourceFunction = resourceGenerator.generateResourceFunction(operation, path);
                }
                catch (BallerinaOpenApiException e) {
                    this.diagnostics.add(e.getDiagnostic());
                    continue;
                }
                this.diagnostics.addAll(resourceGenerator.getDiagnostics());
                functions.add((Node)resourceFunction);
            }
            if (!resourceGenerator.isNullableRequired()) continue;
            this.isNullableRequired = true;
        }
        return functions;
    }
}

