/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.parameter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.service.ServiceGenerationUtils;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnostic;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.openapi.core.generators.service.exceptions.InvalidHeaderNameException;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.parameter.ParameterGenerator;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class HeaderParameterGenerator
extends ParameterGenerator {
    private static final List<String> paramSupportedTypes = new ArrayList<String>(Arrays.asList("integer", "number", "string", "boolean"));

    public HeaderParameterGenerator(OASServiceMetadata oasServiceMetadata) {
        super(oasServiceMetadata);
    }

    @Override
    public ParameterNode generateParameterNode(Parameter parameter) throws UnsupportedOASDataTypeException, InvalidReferenceException, InvalidHeaderNameException {
        BuiltinSimpleNameReferenceNode headerTypeName;
        Schema schema = parameter.getSchema();
        String paramName = parameter.getName().trim();
        AnnotationNode headerNode = ServiceGenerationUtils.getAnnotationNode("Header", null);
        NodeList headerAnnotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{headerNode});
        Optional<String> nameFromExt = GeneratorUtils.getBallerinaNameExtension(parameter);
        if (nameFromExt.isPresent()) {
            paramName = nameFromExt.get();
            headerAnnotations = AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{GeneratorUtils.getNameAnnotationNode(parameter.getName(), "http:Header")});
        }
        String headerType = "string";
        if (parameter.getName().isBlank()) {
            throw new InvalidHeaderNameException();
        }
        IdentifierToken parameterName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier(paramName), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        if (GeneratorUtils.getOpenAPIType(schema) == null && schema.get$ref() == null) {
            this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_106, parameter.getName()));
        } else if (schema.get$ref() != null) {
            String type = GeneratorUtils.extractReferenceType(schema.get$ref());
            Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(type.trim());
            if (paramSupportedTypes.contains(GeneratorUtils.getOpenAPIType(refSchema)) || GeneratorUtils.isArraySchema(refSchema)) {
                TypeHandler.getInstance().getTypeNodeFromOASSchema(schema, false);
                headerType = GeneratorUtils.escapeIdentifier(type);
            } else {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_105, parameter.getName(), GeneratorUtils.getOpenAPIType(refSchema)));
            }
        } else if (paramSupportedTypes.contains(GeneratorUtils.getOpenAPIType(schema)) || GeneratorUtils.isArraySchema(schema)) {
            headerType = GeneratorUtils.convertOpenAPITypeToBallerina(schema, true).trim();
        } else {
            this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_105, parameter.getName(), GeneratorUtils.getOpenAPIType(schema)));
        }
        if (GeneratorUtils.isArraySchema(schema)) {
            Schema items = schema.getItems();
            Object arrayType = "string";
            if (GeneratorUtils.getOpenAPIType(items) == null && items.get$ref() == null) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_104, parameter.getName()));
            } else if (items.get$ref() != null) {
                String type = GeneratorUtils.extractReferenceType(items.get$ref());
                Schema refSchema = (Schema)this.openAPI.getComponents().getSchemas().get(type.trim());
                if (paramSupportedTypes.contains(GeneratorUtils.getOpenAPIType(refSchema))) {
                    arrayType = GeneratorUtils.escapeIdentifier(type);
                } else {
                    this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_103, parameter.getName(), type));
                }
            } else if (!paramSupportedTypes.contains(GeneratorUtils.getOpenAPIType(items))) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_103, parameter.getName(), GeneratorUtils.getOpenAPIType(items)));
            } else {
                arrayType = items.getEnum() != null && !items.getEnum().isEmpty() ? SyntaxKind.OPEN_PAREN_TOKEN.stringValue() + GeneratorUtils.convertOpenAPITypeToBallerina(items, true) + SyntaxKind.CLOSE_PAREN_TOKEN.stringValue() : GeneratorUtils.convertOpenAPITypeToBallerina(items, true);
            }
            BuiltinSimpleNameReferenceNode headerArrayItemTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)arrayType));
            ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
            NodeList nodeList = AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode});
            headerTypeName = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)headerArrayItemTypeName, (NodeList)nodeList);
        } else {
            headerTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)headerType, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE));
        }
        if (!parameter.getRequired().booleanValue()) {
            Object object = headerTypeName = headerTypeName.toString().trim().endsWith("?") ? headerTypeName : NodeFactory.createOptionalTypeDescriptorNode((Node)headerTypeName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (schema.getDefault() != null) {
            return this.getDefaultableHeaderNode(schema, (TypeDescriptorNode)headerTypeName, parameterName, (NodeList<AnnotationNode>)headerAnnotations);
        }
        if (parameter.getRequired().booleanValue() && schema.getNullable() != null && schema.getNullable().equals(true)) {
            this.isNullableRequired = true;
            headerTypeName = headerTypeName.toString().trim().endsWith("?") ? headerTypeName : NodeFactory.createOptionalTypeDescriptorNode((Node)headerTypeName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        return NodeFactory.createRequiredParameterNode((NodeList)headerAnnotations, (Node)headerTypeName, (Token)parameterName);
    }

    private DefaultableParameterNode getDefaultableHeaderNode(Schema<?> schema, TypeDescriptorNode headerTypeName, IdentifierToken parameterName, NodeList<AnnotationNode> headerAnnotations) {
        if (!GeneratorUtils.getOpenAPIType(schema).equals("array")) {
            return NodeFactory.createDefaultableParameterNode(headerAnnotations, (Node)headerTypeName, (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + schema.getDefault().toString() + "\""))));
        }
        return NodeFactory.createDefaultableParameterNode(headerAnnotations, (Node)headerTypeName, (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)schema.getDefault().toString())));
    }
}

