/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.response;

import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.response.DefaultReturnTypeGenerator;
import io.ballerina.openapi.core.generators.service.response.LowResourceReturnTypeGenerator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ReturnTypeGenerator {
    final OASServiceMetadata oasServiceMetadata;
    final String path;
    final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public ReturnTypeGenerator(OASServiceMetadata oasServiceMetadata, String path) {
        this.oasServiceMetadata = oasServiceMetadata;
        this.path = path;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public static ReturnTypeGenerator getReturnTypeGenerator(OASServiceMetadata oasServiceMetadata, String path) {
        if (oasServiceMetadata.generateWithoutDataBinding()) {
            return new LowResourceReturnTypeGenerator(oasServiceMetadata, path);
        }
        return new DefaultReturnTypeGenerator(oasServiceMetadata, path);
    }

    public abstract ReturnTypeDescriptorNode getReturnTypeDescriptorNode(Map.Entry<PathItem.HttpMethod, Operation> var1, String var2) throws BallerinaOpenApiException;
}

