/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service.signature;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnostic;
import io.ballerina.openapi.core.generators.service.exceptions.InvalidHeaderNameException;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.service.parameter.HeaderParameterGenerator;
import io.ballerina.openapi.core.generators.service.parameter.QueryParameterGenerator;
import io.ballerina.openapi.core.generators.service.parameter.RequestBodyGenerator;
import io.ballerina.openapi.core.generators.service.response.ReturnTypeGenerator;
import io.ballerina.openapi.core.generators.service.signature.FunctionSignatureGenerator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultFunctionSignatureGenerator
extends FunctionSignatureGenerator {
    public DefaultFunctionSignatureGenerator(OASServiceMetadata oasServiceMetadata) {
        super(oasServiceMetadata);
    }

    @Override
    public FunctionSignatureNode getFunctionSignature(Map.Entry<PathItem.HttpMethod, Operation> operation, String path) throws BallerinaOpenApiException {
        ParametersGeneratorResult parametersGeneratorResult = this.generateParameters(operation);
        ArrayList<Node> params = new ArrayList<Node>(parametersGeneratorResult.requiredParameters());
        if (operation.getValue().getRequestBody() != null) {
            RequestBody requestBody = operation.getValue().getRequestBody();
            if ((requestBody = this.resolveRequestBodyReference(requestBody)) != null && requestBody.getContent() != null) {
                RequestBodyGenerator requestBodyGenerator = RequestBodyGenerator.getRequestBodyGenerator(this.oasServiceMetadata, path);
                RequiredParameterNode nodeForRequestBody = requestBodyGenerator.createRequestBodyNode(requestBody);
                params.add((Node)nodeForRequestBody);
                params.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                this.diagnostics.addAll(requestBodyGenerator.getDiagnostics());
            }
        }
        if (!parametersGeneratorResult.defaultableParameters().isEmpty()) {
            params.addAll(parametersGeneratorResult.defaultableParameters());
        }
        if (params.size() > 1) {
            params.remove(params.size() - 1);
        }
        SeparatedNodeList parameters = AbstractNodeFactory.createSeparatedNodeList(params);
        ReturnTypeGenerator returnTypeGenerator = ReturnTypeGenerator.getReturnTypeGenerator(this.oasServiceMetadata, path);
        ReturnTypeDescriptorNode returnNode = returnTypeGenerator.getReturnTypeDescriptorNode(operation, path);
        this.diagnostics.addAll(returnTypeGenerator.getDiagnostics());
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameters, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnNode);
    }

    public ParametersGeneratorResult generateParameters(Map.Entry<PathItem.HttpMethod, Operation> operation) throws InvalidHeaderNameException {
        ArrayList<Node> requiredParams = new ArrayList<Node>();
        ArrayList<Node> defaultableParams = new ArrayList<Node>();
        Token comma = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        if (operation.getValue().getParameters() != null) {
            List parameters = operation.getValue().getParameters();
            for (Parameter parameter : parameters) {
                ParameterNode param;
                if (parameter.get$ref() != null) {
                    String referenceType;
                    try {
                        referenceType = GeneratorUtils.extractReferenceType(parameter.get$ref());
                    }
                    catch (InvalidReferenceException e) {
                        Diagnostic diagnostic = e.getDiagnostic();
                        this.diagnostics.add(new ServiceDiagnostic(diagnostic.diagnosticInfo().code(), diagnostic.message(), diagnostic.diagnosticInfo().severity()));
                        return new ParametersGeneratorResult(new ArrayList<Node>(), new ArrayList<Node>());
                    }
                    parameter = (Parameter)this.oasServiceMetadata.getOpenAPI().getComponents().getParameters().get(referenceType);
                }
                if (parameter.getIn().trim().equals("header")) {
                    HeaderParameterGenerator headerParamGenerator = new HeaderParameterGenerator(this.oasServiceMetadata);
                    try {
                        param = headerParamGenerator.generateParameterNode(parameter);
                    }
                    catch (InvalidReferenceException | UnsupportedOASDataTypeException e) {
                        this.diagnostics.add(e.getDiagnostic());
                        continue;
                    }
                    this.diagnostics.addAll(headerParamGenerator.getDiagnostics());
                    if (headerParamGenerator.isNullableRequired()) {
                        this.isNullableRequired = true;
                    }
                    if (param.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
                        defaultableParams.add((Node)param);
                        defaultableParams.add((Node)comma);
                        continue;
                    }
                    requiredParams.add((Node)param);
                    requiredParams.add((Node)comma);
                    continue;
                }
                if (!parameter.getIn().trim().equals("query")) continue;
                if (parameter.getRequired() != null && parameter.getRequired().booleanValue() && parameter.getSchema() != null && parameter.getSchema().getNullable() != null && parameter.getSchema().getNullable().booleanValue()) {
                    this.isNullableRequired = true;
                }
                QueryParameterGenerator queryParameterGenerator = new QueryParameterGenerator(this.oasServiceMetadata);
                try {
                    param = queryParameterGenerator.generateParameterNode(parameter);
                }
                catch (InvalidReferenceException | UnsupportedOASDataTypeException e) {
                    this.diagnostics.add(e.getDiagnostic());
                    continue;
                }
                this.diagnostics.addAll(queryParameterGenerator.getDiagnostics());
                if (param == null) continue;
                if (param.kind() == SyntaxKind.DEFAULTABLE_PARAM) {
                    defaultableParams.add((Node)param);
                    defaultableParams.add((Node)comma);
                    continue;
                }
                requiredParams.add((Node)param);
                requiredParams.add((Node)comma);
            }
        }
        return new ParametersGeneratorResult(requiredParams, defaultableParams);
    }

    private RequestBody resolveRequestBodyReference(RequestBody requestBody) {
        if (requestBody.get$ref() != null) {
            try {
                String requestBodyName = GeneratorUtils.extractReferenceType(requestBody.get$ref());
                requestBody = this.resolveRequestBodyReference((RequestBody)this.oasServiceMetadata.getOpenAPI().getComponents().getRequestBodies().get(requestBodyName.trim()));
            }
            catch (InvalidReferenceException e) {
                this.diagnostics.add(e.getDiagnostic());
                return null;
            }
        }
        return requestBody;
    }

    public record ParametersGeneratorResult(List<Node> requiredParameters, List<Node> defaultableParameters) {
    }
}

