/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneratorConstants {
    public static final String TYPE_FILE_NAME = "types.bal";
    public static final String CLIENT_FILE_NAME = "client.bal";
    public static final String UTIL_FILE_NAME = "utils.bal";
    public static final String TEST_FILE_NAME = "test.bal";
    public static final String SERVICE_FILE_NAME = "service.bal";
    public static final String CONFIG_FILE_NAME = "Config.toml";
    public static final String BALLERINA_TOML = "Ballerina.toml";
    public static final String BALLERINA_TOML_CONTENT = "[package]\norg= \"ballerina\"\nname= \"testopenapi\"\nversion= \"0.0.0\"\n";
    public static final String OAS_PATH_SEPARATOR = "/";
    public static final String ESCAPE_PATTERN = "([\\[\\]\\\\?!<>@#&~'`*\\-=^+();:\\/{}\\s|.$])";
    public static final String REGEX_WITHOUT_SPECIAL_CHARACTERS = "\\b[_a-zA-Z][_a-zA-Z0-9]*\\b";
    public static final String REGEX_WORDS_STARTING_WITH_NUMBERS = "^[0-9].*";
    public static final String REGEX_ONLY_NUMBERS_OR_NUMBERS_WITH_SPECIAL_CHARACTERS = "\\b[0-9([\\[\\]\\\\?!<>@#&~'`*\\-=^+();:\\/{}\\s|.$])]*\\b";
    public static final String HTTP = "http";
    public static final String URL = "url";
    public static final String BALLERINA = "ballerina";
    public static final String STRING = "string";
    public static final String XML = "xml";
    public static final String BYTE = "byte";
    public static final String JSON = "json";
    public static final String SERVICE_URL = "serviceUrl";
    public static final String IDENTIFIER = "identifier";
    public static final String TYPE_NAME = "typeName";
    public static final String BINARY = "binary";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String HTTP_REQUEST = "http:Request";
    public static final String PDF = "pdf";
    public static final String MIME = "mime";
    public static final String ARRAY = "array";
    public static final String ERROR = "error";
    public static final String MAP_JSON = "map<json>";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_URL_ENCODE = "application/x-www-form-urlencoded";
    public static final String TEXT = "text";
    public static final String IMAGE_PNG = "image/png";
    public static final String ENSURE_TYPE = "ensureType";
    public static final String API_KEY = "apikey";
    public static final String CONNECTION_CONFIG = "ConnectionConfig";
    public static final String ANY_DATA = "anydata";
    public static final String POST = "post";
    public static final String GET = "get";
    public static final String PUT = "put";
    public static final String DELETE = "delete";
    public static final String PATCH = "patch";
    public static final String EXECUTE = "execute";
    public static final String HEAD = "head";
    public static final String OPTIONS = "options";
    public static final String FORM = "FORM";
    public static final String STYLE = "style";
    public static final String EXPLODE = "explode";
    public static final String HTTP_RESPONSE = "http:Response";
    public static final Map<String, String> HTTP_CODES_DES;
    public static final String HTTP_200 = "200";
    public static final String HTTP_201 = "201";
    public static final String INTEGER = "integer";
    public static final String BOOLEAN = "boolean";
    public static final String NUMBER = "number";
    public static final String OBJECT = "object";
    public static final Integer MAX_ARRAY_LENGTH;
    public static final String NILLABLE = "?";
    public static final String SQUARE_BRACKETS = "[]";
    public static final Map<String, List<String>> OPENAPI_TYPE_TO_FORMAT_MAP;
    public static final Map<String, String> OPENAPI_TYPE_TO_BAL_TYPE_MAP;
    public static final String DEFAULT_HTTP_VERSION = "2.0";
    public static final Map<String, String> HTTP_VERSION_MAP;
    public static final String UNSUPPORTED_MEDIA_ERROR = "Unsupported media type '%s' is given in the request body";
    public static final String LINE_SEPARATOR;
    public static final String DOUBLE_LINE_SEPARATOR;
    public static final String DEFAULT_RETURN = "http:Response|error";
    public static final String TREAT_NILABLE_AS_OPTIONAL = "treatNilableAsOptional";
    public static final String SERVICE_CONFIG = "http:ServiceConfig";
    public static final String FALSE = "false";
    public static final String HEADER_ANNOT = "Header";
    public static final String MAP_STRING = "map<string>";
    public static final String TEXT_WILDCARD_REGEX = "text/.*";
    public static final String BODY = "body";
    public static final String SPECIAL_CHARACTERS_REGEX = "[^a-zA-Z0-9]";
    public static final String OPEN_CURLY_BRACE = "{";
    public static final String CLOSE_CURLY_BRACE = "}";
    public static final String SLASH = "/";
    public static final String CATCH_ALL_PATH = "/*";
    public static final String CONSTRAINT = "constraint";
    public static final String CONSTRAINT_STRING = "constraint:String";
    public static final String CONSTRAINT_NUMBER = "constraint:Number";
    public static final String CONSTRAINT_FLOAT = "constraint:Float";
    public static final String CONSTRAINT_INT = "constraint:Int";
    public static final String CONSTRAINT_ARRAY = "constraint:Array";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MIN_LENGTH = "minLength";
    public static final String MINIMUM = "minValue";
    public static final String MAXIMUM = "maxValue";
    public static final String EXCLUSIVE_MAX = "maxValueExclusive";
    public static final String EXCLUSIVE_MIN = "minValueExclusive";
    public static final String SPECIAL_CHARACTER_REGEX = "([\\[\\]\\\\?!<>@#&~`*\\-=^+'();:\\/\\_{}\\s|.$])";
    public static final String HTTP_VERSION = "http:HttpVersion";
    public static final String YAML_EXTENSION = ".yaml";
    public static final String YML_EXTENSION = ".yml";
    public static final String JSON_EXTENSION = ".json";
    public static final String UNSUPPORTED_OPENAPI_VERSION_PARSER_MESSAGE = "attribute swaggerVersion is unexpected";
    public static final String NULL = "null";
    public static final String INT = "int";
    public static final String INT_SIGNED32 = "int:Signed32";
    public static final String DECIMAL = "decimal";
    public static final String RETURN = "return";
    public static final String OPTIONAL_ERROR = "error?";

    static {
        HashMap<String, String> httpCodeMap = new HashMap<String, String>();
        httpCodeMap.put("100", "Continue");
        httpCodeMap.put("101", "SwitchingProtocols");
        httpCodeMap.put("102", "Processing");
        httpCodeMap.put("103", "EarlyHints");
        httpCodeMap.put(HTTP_200, "Ok");
        httpCodeMap.put(HTTP_201, "Created");
        httpCodeMap.put("202", "Accepted");
        httpCodeMap.put("203", "NonAuthoritativeInformation");
        httpCodeMap.put("204", "NoContent");
        httpCodeMap.put("205", "ResetContent");
        httpCodeMap.put("206", "PartialContent");
        httpCodeMap.put("207", "MultiStatus");
        httpCodeMap.put("208", "AlreadyReported");
        httpCodeMap.put("226", "IMUsed");
        httpCodeMap.put("300", "MultipleChoices");
        httpCodeMap.put("301", "MovedPermanently");
        httpCodeMap.put("302", "Found");
        httpCodeMap.put("303", "SeeOther");
        httpCodeMap.put("304", "NotModified");
        httpCodeMap.put("305", "UseProxy");
        httpCodeMap.put("307", "TemporaryRedirect");
        httpCodeMap.put("308", "PermanentRedirect");
        httpCodeMap.put("400", "BadRequest");
        httpCodeMap.put("401", "Unauthorized");
        httpCodeMap.put("402", "PaymentRequired");
        httpCodeMap.put("403", "Forbidden");
        httpCodeMap.put("404", "NotFound");
        httpCodeMap.put("405", "MethodNotAllowed");
        httpCodeMap.put("406", "NotAcceptable");
        httpCodeMap.put("407", "ProxyAuthenticationRequired");
        httpCodeMap.put("408", "RequestTimeout");
        httpCodeMap.put("409", "Conflict");
        httpCodeMap.put("410", "Gone");
        httpCodeMap.put("411", "LengthRequired");
        httpCodeMap.put("412", "PreconditionFailed");
        httpCodeMap.put("413", "PayloadTooLarge");
        httpCodeMap.put("414", "UriTooLong");
        httpCodeMap.put("415", "UnsupportedMediaType");
        httpCodeMap.put("416", "RangeNotSatisfiable");
        httpCodeMap.put("417", "ExpectationFailed");
        httpCodeMap.put("421", "MisdirectedRequest");
        httpCodeMap.put("422", "UnprocessableEntity");
        httpCodeMap.put("423", "Locked");
        httpCodeMap.put("424", "FailedDependency");
        httpCodeMap.put("425", "TooEarly");
        httpCodeMap.put("426", "UpgradeRequired");
        httpCodeMap.put("428", "PreconditionRequired");
        httpCodeMap.put("429", "TooManyRequests");
        httpCodeMap.put("431", "RequestHeaderFieldsTooLarge");
        httpCodeMap.put("451", "UnavailableDueToLegalReasons");
        httpCodeMap.put("500", "InternalServerError");
        httpCodeMap.put("501", "NotImplemented");
        httpCodeMap.put("502", "BadGateway");
        httpCodeMap.put("503", "ServiceUnavailable");
        httpCodeMap.put("504", "GatewayTimeout");
        httpCodeMap.put("505", "HttpVersionNotSupported");
        httpCodeMap.put("506", "VariantAlsoNegotiates");
        httpCodeMap.put("507", "InsufficientStorage");
        httpCodeMap.put("508", "LoopDetected");
        httpCodeMap.put("510", "NotExtended");
        httpCodeMap.put("511", "NetworkAuthenticationRequired");
        HTTP_CODES_DES = Collections.unmodifiableMap(httpCodeMap);
        MAX_ARRAY_LENGTH = 0x7FFFFFF5;
        HashMap<String, List<String>> typeToFormatMap = new HashMap<String, List<String>>();
        typeToFormatMap.put(INTEGER, List.of("int32", "int64"));
        typeToFormatMap.put(NUMBER, List.of(FLOAT, DOUBLE));
        typeToFormatMap.put(STRING, List.of("date", "date-time", "password", BYTE, BINARY));
        OPENAPI_TYPE_TO_FORMAT_MAP = Collections.unmodifiableMap(typeToFormatMap);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put(INTEGER, INT);
        typeMap.put(STRING, STRING);
        typeMap.put(BOOLEAN, BOOLEAN);
        typeMap.put(ARRAY, SQUARE_BRACKETS);
        typeMap.put(OBJECT, "record {}");
        typeMap.put(DECIMAL, DECIMAL);
        typeMap.put(NUMBER, DECIMAL);
        typeMap.put(DOUBLE, DECIMAL);
        typeMap.put(FLOAT, FLOAT);
        typeMap.put(BINARY, "byte[]");
        typeMap.put(BYTE, STRING);
        typeMap.put("int32", INT_SIGNED32);
        typeMap.put("int64", INT);
        OPENAPI_TYPE_TO_BAL_TYPE_MAP = Collections.unmodifiableMap(typeMap);
        HashMap<String, String> httpVersionMap = new HashMap<String, String>();
        httpVersionMap.put("1.0", "http:HTTP_1_0");
        httpVersionMap.put("1.1", "http:HTTP_1_1");
        httpVersionMap.put(DEFAULT_HTTP_VERSION, "http:HTTP_2_0");
        HTTP_VERSION_MAP = Collections.unmodifiableMap(httpVersionMap);
        LINE_SEPARATOR = System.lineSeparator();
        DOUBLE_LINE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
    }

    public static enum AuthConfigTypes {
        BASIC("http:CredentialsConfig"),
        BEARER("http:BearerTokenConfig"),
        CLIENT_CREDENTIAL("http:OAuth2ClientCredentialsGrantConfig"),
        CUSTOM_CLIENT_CREDENTIAL("OAuth2ClientCredentialsGrantConfig"),
        REFRESH_TOKEN("http:OAuth2RefreshTokenGrantConfig"),
        CUSTOM_REFRESH_TOKEN("OAuth2RefreshTokenGrantConfig"),
        PASSWORD("http:OAuth2PasswordGrantConfig"),
        CUSTOM_PASSWORD("OAuth2PasswordGrantConfig");

        private final String authType;

        private AuthConfigTypes(String authType) {
            this.authType = authType;
        }

        public String getValue() {
            return this.authType;
        }
    }

    public static enum GenType {
        GEN_SERVICE("gen_service"),
        GEN_CLIENT("gen_client"),
        GEN_BOTH("gen_both");

        private String name;

        private GenType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

