/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.type.generators.AllOfRecordTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.AnyDataTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.ArrayTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.PrimitiveTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.RecordTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.ReferencedTypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.ballerina.openapi.core.generators.type.generators.UnionTypeGenerator;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TypeGeneratorUtils {
    public static final List<String> PRIMITIVE_TYPE_LIST = Collections.unmodifiableList(Arrays.asList("integer", "number", "string", "boolean"));

    public static TypeGenerator getTypeGenerator(Schema<?> schemaValue, String typeName, String parentName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        if (schemaValue.get$ref() != null) {
            return new ReferencedTypeGenerator(schemaValue, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
        }
        if (GeneratorUtils.isComposedSchema(schemaValue)) {
            if (schemaValue.getAllOf() != null) {
                return new AllOfRecordTypeGenerator(schemaValue, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
            }
            return new UnionTypeGenerator(schemaValue, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
        }
        if (GeneratorUtils.getOpenAPIType(schemaValue) != null && GeneratorUtils.getOpenAPIType(schemaValue).equals("object") || GeneratorUtils.isObjectSchema(schemaValue) || schemaValue.getProperties() != null || GeneratorUtils.isMapSchema(schemaValue)) {
            return new RecordTypeGenerator(schemaValue, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
        }
        if (GeneratorUtils.isArraySchema(schemaValue)) {
            return new ArrayTypeGenerator(schemaValue, typeName, ignoreNullableFlag, parentName, subTypesMap, pregeneratedTypeMap);
        }
        if (GeneratorUtils.getOpenAPIType(schemaValue) != null && PRIMITIVE_TYPE_LIST.contains(GeneratorUtils.getOpenAPIType(schemaValue))) {
            return new PrimitiveTypeGenerator(schemaValue, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
        }
        return new AnyDataTypeGenerator(schemaValue, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
    }

    public static TypeDescriptorNode getNullableType(Schema schema, TypeDescriptorNode originalTypeDesc, boolean ignoreNullableFlag) {
        TypeDescriptorNode nillableType = originalTypeDesc;
        boolean nullable = GeneratorMetaData.getInstance().isNullable();
        if (schema.getNullable() != null) {
            if (schema.getNullable().booleanValue()) {
                nillableType = NodeFactory.createOptionalTypeDescriptorNode((Node)originalTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
            }
        } else if (schema.getTypes() != null && schema.getTypes().contains("null")) {
            nillableType = NodeFactory.createOptionalTypeDescriptorNode((Node)originalTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        } else if (!ignoreNullableFlag && nullable) {
            nillableType = NodeFactory.createOptionalTypeDescriptorNode((Node)originalTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        return nillableType;
    }
}

