/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.type.generators;

import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.UnsupportedOASDataTypeException;
import io.ballerina.openapi.core.generators.type.TypeGeneratorUtils;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.openapi.core.generators.type.generators.EnumGenerator;
import io.ballerina.openapi.core.generators.type.generators.TypeGenerator;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;

public class PrimitiveTypeGenerator
extends TypeGenerator {
    public PrimitiveTypeGenerator(Schema schema, String typeName, boolean ignoreNullableFlag, HashMap<String, TypeDefinitionNode> subTypesMap, HashMap<String, NameReferenceNode> pregeneratedTypeMap) {
        super(schema, typeName, ignoreNullableFlag, subTypesMap, pregeneratedTypeMap);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws OASTypeGenException {
        String typeDescriptorName;
        try {
            typeDescriptorName = GeneratorUtils.convertOpenAPITypeToBallerina(this.schema, this.ignoreNullableFlag);
        }
        catch (UnsupportedOASDataTypeException e) {
            throw new OASTypeGenException(e.getDiagnostic().message());
        }
        if (this.schema.getEnum() != null && this.schema.getEnum().size() > 0) {
            EnumGenerator enumGenerator = new EnumGenerator(this.schema, this.typeName, this.ignoreNullableFlag, this.subTypesMap, this.pregeneratedTypeMap);
            return enumGenerator.generateTypeDescriptorNode();
        }
        if (GeneratorUtils.getOpenAPIType(this.schema).equals("string") && this.schema.getFormat() != null && this.schema.getFormat().equals("binary")) {
            typeDescriptorName = "record {byte[] fileContent; string fileName;}";
        }
        TypeDescriptorNode typeDescriptorNode = NodeParser.parseTypeDescriptor((String)typeDescriptorName);
        return TypeGeneratorUtils.getNullableType(this.schema, typeDescriptorNode, this.ignoreNullableFlag);
    }
}

